/*

 Licensed under the Apache License, Version 2.0 (the "License"); you may not
 use this file except in compliance with the License. You may obtain a copy 
 of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 License for the specific language governing permissions and limitations under
 the License.

 Copyright (c) 2011-2012 Almende B.V.

 @author 	Jos de Jong, <jos@almende.org>
 @date    2012-03-19
*/
typeof links==="undefined"&&(links={});typeof google==="undefined"&&(google=void 0);
links.Network=function(a){this.containerElement=a;this.height=this.width="100%";this.refreshRate=50;this.selectable=this.stabilize=!0;this.constants={nodes:{radiusMin:5,radiusMax:20,radius:5,distance:100,style:"rect",image:void 0,widthMin:16,widthMax:64,fontColor:"black",fontSize:14,fontFace:"arial",borderColor:"#2B7CE9",backgroundColor:"#97C2FC",highlightColor:"#D2E5FF",group:void 0},links:{widthMin:1,widthMax:15,width:1,style:"line",color:"#2B7CE9",length:100},packages:{radius:5,radiusMin:5,radiusMax:10,
style:"dot",color:"#2B7CE9",image:void 0,widthMin:16,widthMax:64,duration:1},minVelocity:0.01,maxIterations:1E3};this.nodes=[];this.links=[];this.packages=[];this.images=new links.Network.Images;this.groups=new links.Network.Groups;this.hasMovingPackages=this.hasMovingNodes=this.hasMovingLinks=!1;this.timer=void 0;this._create()};
links.Network.prototype.draw=function(a,b,e,c){if(c!=void 0)var f=a,g=b,h=e;else e!=void 0?(f=a,g=b,h=void 0,c=e):b!=void 0?(f=a,h=g=void 0,c=b):a!=void 0&&(h=g=f=void 0,c=a);if(c!=void 0){if(c.width!=void 0)this.width=c.width;if(c.height!=void 0)this.height=c.height;if(c.stabilize!=void 0)this.stabilize=c.stabilize;if(c.selectable!=void 0)this.selectable=c.selectable;if(c.links){for(prop in c.links)c.links.hasOwnProperty(prop)&&(this.constants.links[prop]=c.links[prop]);if(c.links.length!=void 0&&
c.links.distance==void 0)this.constants.links.length=c.links.length,this.constants.nodes.distance=c.links.length*1.25}if(c.nodes)for(prop in c.nodes)c.nodes.hasOwnProperty(prop)&&(this.constants.nodes[prop]=c.nodes[prop]);if(c.packages)for(prop in c.packages)c.packages.hasOwnProperty(prop)&&(this.constants.packages[prop]=c.packages[prop]);if(c.groups)for(groupname in c.groups)c.groups.hasOwnProperty(groupname)&&this.groups.add(groupname,c.groups[groupname])}this._setBackgroundColor(c.backgroundColor);
this._setSize(this.width,this.height);this._setTranslation(0,0);this._setScale(1);this.hasTimestamps=!1;this.setNodes(f);this.setLinks(g);this.setPackages(h);this._reposition();this.stabilize&&this._doStabilize();this.start();var i=this;this.images.setOnloadCallback(function(){i._redraw()});this.trigger("ready")};links.Network.prototype.trigger=function(a,b){links.events.trigger(this,a,b);google&&google.visualization&&google.visualization.events&&google.visualization.events.trigger(this,a,b)};
links.Network.prototype._create=function(){for(;this.containerElement.hasChildNodes();)this.containerElement.removeChild(this.containerElement.firstChild);this.frame=document.createElement("div");this.frame.className="network-frame";this.frame.style.position="relative";this.frame.style.overflow="hidden";this.frame.canvas=document.createElement("canvas");this.frame.canvas.style.position="relative";this.frame.appendChild(this.frame.canvas);if(!this.frame.canvas.getContext){var a=document.createElement("DIV");
a.style.color="red";a.style.fontWeight="bold";a.style.padding="10px";a.innerHTML="Error: your browser does not support HTML canvas";this.frame.canvas.appendChild(a)}var b=this;links.Network.addEventListener(this.frame.canvas,"mousedown",function(a){b._onMouseDown(a)});links.Network.addEventListener(this.frame.canvas,"mousemove",function(a){b._onMouseMoveTitle(a)});links.Network.addEventListener(this.frame.canvas,"mousewheel",function(a){b._onMouseWheel(a)});links.Network.addEventListener(this.frame.canvas,
"touchstart",function(a){b._onTouchStart(a)});this.containerElement.appendChild(this.frame)};
links.Network.prototype._setBackgroundColor=function(a){var b="white",e="#666",c=1;if(typeof a=="string")b=a,e="none",c=0;else if(typeof a=="object"){if(a.fill!=void 0)b=a.fill;if(a.stroke!=void 0)e=a.stroke;if(a.strokeWidth!=void 0)c=a.strokeWidth}else if(a!=void 0)throw"Unsupported type of backgroundColor";this.frame.style.backgroundColor=b;this.frame.style.borderColor=e;this.frame.style.borderWidth=c+"px";this.frame.style.borderStyle="solid"};
links.Network.prototype._onMouseDown=function(a){a=a||window.event;if(this.selectable&&(this.leftButtonDown&&this._onMouseUp(a),(this.leftButtonDown=a.which?a.which==1:a.button==1)||this.touchDown)){var b=this;this.onmousemove=function(a){b._onMouseMove(a)};this.onmouseup=function(a){b._onMouseUp(a)};links.Network.addEventListener(document,"mousemove",b.onmousemove);links.Network.addEventListener(document,"mouseup",b.onmouseup);links.Network.preventDefault(a);this.startMouseX=a.clientX||a.targetTouches[0].clientX;
this.startMouseY=a.clientY||a.targetTouches[0].clientY;this.startFrameLeft=links.Network._getAbsoluteLeft(this.frame.canvas);this.startFrameTop=links.Network._getAbsoluteTop(this.frame.canvas);this.startTranslation=this._getTranslation();this.ctrlKeyDown=a.ctrlKey;this.shiftKeyDown=a.shiftKey;a=this._getNodesOverlappingWith({left:this._xToCanvas(this.startMouseX-this.startFrameLeft),top:this._yToCanvas(this.startMouseY-this.startFrameTop),right:this._xToCanvas(this.startMouseX-this.startFrameLeft),
bottom:this._yToCanvas(this.startMouseY-this.startFrameTop)});if(this.startClickedObj=a.length>0?a[a.length-1]:void 0)a=this.nodes[this.startClickedObj.row],this.startClickedObj.xFixed=a.xFixed,this.startClickedObj.yFixed=a.yFixed,a.xFixed=!0,a.yFixed=!0,!this.ctrlKeyDown||!a.isSelected()?this._selectNodes([this.startClickedObj],this.ctrlKeyDown):this._unselectNodes([this.startClickedObj]),this.hasMovingNodes||this._redraw();else if(!this.shiftKeyDown)this.moved=!1}};
links.Network.prototype._onMouseMove=function(a){a=a||window.event;if(this.selectable){var b=a.clientX||a.targetTouches&&a.targetTouches[0].clientX||0,e=a.clientY||a.targetTouches&&a.targetTouches[0].clientY||0;this.mouseX=b;this.mouseY=e;if(this.startClickedObj){var c=this.nodes[this.startClickedObj.row];if(!this.startClickedObj.xFixed)c.x=this._xToCanvas(b-this.startFrameLeft);if(!this.startClickedObj.yFixed)c.y=this._yToCanvas(e-this.startFrameTop);if(!this.hasMovingNodes)this.hasMovingNodes=!0,
this.start()}else if(this.shiftKeyDown){if(this.frame.selRect==void 0)this.frame.selRect=document.createElement("DIV"),this.frame.appendChild(this.frame.selRect),this.frame.selRect.style.position="absolute",this.frame.selRect.style.border="1px dashed red";var c=Math.min(this.startMouseX,b)-this.startFrameLeft,f=Math.min(this.startMouseY,e)-this.startFrameTop,b=Math.max(this.startMouseX,b)-this.startFrameLeft,e=Math.max(this.startMouseY,e)-this.startFrameTop;this.frame.selRect.style.left=c+"px";this.frame.selRect.style.top=
f+"px";this.frame.selRect.style.width=b-c+"px";this.frame.selRect.style.height=e-f+"px"}else this._setTranslation(this.startTranslation.x+(b-this.startMouseX),this.startTranslation.y+(e-this.startMouseY)),this._redraw(),this.moved=!0;links.Network.preventDefault(a)}};
links.Network.prototype._onMouseUp=function(a){a=a||window.event;if(this.selectable){links.Network.removeEventListener(document,"mousemove",this.onmousemove);links.Network.removeEventListener(document,"mouseup",this.onmouseup);links.Network.preventDefault(a);var b=a.clientX||this.mouseX||0,e=a.clientY||this.mouseY||0,a=a?a.ctrlKey:window.event.ctrlKey;if(this.startClickedObj)b=this.nodes[this.startClickedObj.row],b.xFixed=this.startClickedObj.xFixed,b.yFixed=this.startClickedObj.yFixed;else if(this.shiftKeyDown){if(this._selectNodes(this._getNodesOverlappingWith({left:this._xToCanvas(Math.min(this.startMouseX,
b)-this.startFrameLeft),top:this._yToCanvas(Math.min(this.startMouseY,e)-this.startFrameTop),right:this._xToCanvas(Math.max(this.startMouseX,b)-this.startFrameLeft),bottom:this._yToCanvas(Math.max(this.startMouseY,e)-this.startFrameTop)}),a),this.redraw(),this.frame.selRect)this.frame.removeChild(this.frame.selRect),this.frame.selRect=void 0}else!this.ctrlKeyDown&&!this.moved&&(this._unselectNodes(),this._redraw());this.ctrlKeyDown=this.leftButtonDown=!1}};
links.Network.prototype._onMouseWheel=function(a){var a=a||window.event,b=a.clientX,e=a.clientY,c=0;a.wheelDelta?c=a.wheelDelta/120:a.detail&&(c=-a.detail/3);if(c){var f=c/10;c<0&&(f/=1-f);c=this._getScale();f=c*(1+f);f<0.01&&(f=0.01);f>10&&(f=10);var g=links.Network._getAbsoluteLeft(this.frame.canvas),h=links.Network._getAbsoluteTop(this.frame.canvas);b-=g;e-=h;h=this._getTranslation();c=f/c;b=(1-c)*b+h.x*c;c=(1-c)*e+h.y*c;this._setScale(f);this._setTranslation(b,c);this._redraw()}links.Network.preventDefault(a)};
links.Network.prototype._onMouseMoveTitle=function(a){var a=a||window.event,b=a.clientX,a=a.clientY;this.startFrameLeft=this.startFrameLeft||links.Network._getAbsoluteLeft(this.frame.canvas);this.startFrameTop=this.startFrameTop||links.Network._getAbsoluteTop(this.frame.canvas);var e=b-this.startFrameLeft,c=a-this.startFrameTop;this.popupNode&&this._checkHidePopup(e,c);var f=this,b=function(){f._checkShowPopup(e,c)};this.popupTimer&&clearInterval(this.popupTimer);if(!this.leftButtonDown)this.popupTimer=
setTimeout(b,300)};
links.Network.prototype._checkShowPopup=function(a,b){var e={left:this._xToCanvas(a),top:this._yToCanvas(b),right:this._xToCanvas(a),bottom:this._yToCanvas(b)},c=this.popupNode;if(this.popupNode==void 0)for(var f=0,g=this.packages.length;f<g;f++){var h=this.packages[f];if(h.getTitle()!=void 0&&h.isOverlappingWith(e)){this.popupNode=h;break}}if(this.popupNode==void 0){g=this.nodes;for(f=g.length-1;f>0;f--)if(h=g[f],h.getTitle()!=void 0&&h.isOverlappingWith(e)){this.popupNode=h;break}}if(this.popupNode==void 0){h=
this.links;f=0;for(g=h.length;f<g;f++){var i=h[f];if(i.getTitle()!=void 0&&i.isOverlappingWith(e)){this.popupNode=i;break}}}if(this.popupNode){if(this.popupNode!=c){if(!this.popup)this.popup=new links.Network.Popup(this.frame);this.popup.setPosition(a-3,b-3);this.popup.setText(this.popupNode.getTitle());this.popup.show()}}else this.popup&&this.popup.hide()};
links.Network.prototype._checkHidePopup=function(a,b){var e={left:a,top:b,right:a,bottom:b};if(!this.popupNode||!this.popupNode.isOverlappingWith(e))this.popupNode=void 0,this.popup&&this.popup.hide()};
links.Network.prototype._onTouchStart=function(a){this.touchDown=!0;var b=this;this.ontouchmove=function(a){b._onTouchMove(a)};this.ontouchend=function(a){b._onTouchEnd(a)};links.Network.addEventListener(document,"touchmove",b.ontouchmove);links.Network.addEventListener(document,"touchend",b.ontouchend);this._onMouseDown(a)};links.Network.prototype._onTouchMove=function(a){this._onMouseMove(a)};
links.Network.prototype._onTouchEnd=function(a){this.touchDown=!1;links.Network.removeEventListener(document,"touchmove",this.ontouchmove);links.Network.removeEventListener(document,"touchend",this.ontouchend);this._onMouseUp(a)};
links.Network.prototype._unselectNodes=function(a,b){var e=!1;if(a)for(var c=0,f=a.length;c<f;c++){var g=a[c].row;this.nodes[g].unselect();for(var h=0;h<this.selection.length;)this.selection[h].row==g?(this.selection.splice(h,1),e=!0):h++}else if(this.selection){c=0;for(f=this.selection.length;c<f;c++)g=this.selection[c].row,this.nodes[g].unselect(),e=!0;this.selection=[]}e&&(b==!0||b==void 0)&&this.trigger("select");return e};
links.Network.prototype._selectNodes=function(a,b){var e=!1,c=!0;if(a.length!=this.selection.length)c=!1;else for(var f=0,g=Math.min(a.length,this.selection.length);f<g;f++)if(a[f].row!=this.selection[f].row){c=!1;break}if(!c){if(b==void 0||b==!1)e=this._unselectNodes(void 0,!1);f=0;for(g=a.length;f<g;f++){for(var c=a[f].row,h=!1,i=0,j=this.selection.length;i<j;i++)if(this.selection[i].row==c){h=!0;break}h||(this.nodes[c].select(),this.selection.push(a[f]),e=!0)}e&&this.trigger("select");return e}};
links.Network.prototype._getNodesOverlappingWith=function(a){for(var b=[],e=0;e<this.nodes.length;e++)this.nodes[e].isOverlappingWith(a)&&b.push({row:e});return b};links.Network.prototype.getSelection=function(){for(var a=[],b=0;b<this.selection.length;b++)a.push({row:this.selection[b].row});return a};
links.Network.prototype.setSelection=function(a){if(a.length==void 0)throw"Selection must be an array with objects";for(var b=0,e=this.selection.length;b<e;b++){var c=this.selection[b].row;this.nodes[c].unselect()}this.selection=[];b=0;for(e=a.length;b<e;b++){c=a[b].row;if(c==void 0)throw"Parameter row missing in selection object";if(c>this.nodes.length-1)throw"Parameter row out of range";this.selection.push({row:c});this.nodes[c].select()}this.redraw()};
links.Network.prototype._getConnectionCount=function(a){function b(a){for(var b=[],c=0,f=a.length;c<f;c++)for(var g=a[c],h=0,i=e.length;h<i;h++){var j=null;if(e[h].from==g)j=e[h].to;else if(e[h].to==g)j=e[h].from;if(j)for(var l=0,m=a.length;l<m;l++)if(a[l]==j){j=null;break}if(j){l=0;for(m=b.length;l<m;l++)if(b[l]==j){j=null;break}}j&&b.push(j)}return b}var e=this.links;a==void 0&&(a=1);for(var c=[],f=this.nodes,g=0,h=f.length;g<h;g++){for(var i=[f[g]],j=0;j<a;j++)i=i.concat(b(i));c.push(i)}a=[];g=
0;for(f=c.length;g<f;g++)a.push(c[g].length);return a};links.Network.prototype._setSize=function(a,b){this.frame.style.width=a;this.frame.style.height=b;this.frame.canvas.style.width="100%";this.frame.canvas.style.height="100%";this.frame.canvas.width=this.frame.canvas.clientWidth;this.frame.canvas.height=this.frame.canvas.clientHeight;this.slider&&this.slider.redraw()};
links.Network.tableToArray=function(a){for(var b=[],e=a.getNumberOfColumns(),c={},f=0;f<e;f++){var g=a.getColumnLabel(f);c[g]=f}e=a.getNumberOfRows();for(g=0;g<e;g++){var h={};for(f in c)if(c.hasOwnProperty(f)){var i=a.getValue(g,c[f]);h[f]=i}b.push(h)}return b};
links.Network.prototype.addNodes=function(a){if(google&&google.visualization&&google.visualization.DataTable&&a instanceof google.visualization.DataTable)a=links.Network.tableToArray(a);else if(!links.Network.isArray(a))return;for(var b=!1,e=a.length,c=0;c<e;c++){var f=a[c];f.value!=void 0&&(b=!0);if(f.id==void 0)throw"Column 'id' missing in table with nodes (row "+c+")";this._createNode(f)}b&&this._updateValueRange(this.nodes);this.start()};
links.Network.prototype.setNodes=function(a){if(google&&google.visualization&&google.visualization.DataTable&&a instanceof google.visualization.DataTable)a=links.Network.tableToArray(a);else if(!links.Network.isArray(a))return;this.hasMovingNodes=!1;this.nodesTable=a;this.nodes=[];this.selection=[];for(var b=!1,e=a.length,c=0;c<e;c++){var f=a[c];f.value!=void 0&&(b=!0);if(f.timestamp)this.hasTimestamps=this.hasTimestamps||f.timestamp;if(f.id==void 0)throw"Column 'id' missing in table with nodes (row "+
c+")";this._createNode(f)}b&&this._updateValueRange(this.nodes)};links.Network.prototype._filterNodes=function(a){if(this.nodesTable!=void 0){if(a!==void 0)for(var b=this.nodes,e=0;e<b.length;){var c=b[e].timestamp;c!==void 0&&c>a?b.splice(e,1):e++}b=this.nodesTable;e=b.length;for(c=0;c<e;c++){var f=b[c];if(f.id===void 0)throw"Column 'id' missing in table with nodes (row "+c+")";var g=f.timestamp?f.timestamp:void 0,h=!0;g!==void 0&&a!==void 0&&g>a&&(h=!1);h&&this._createNode(f)}this.start()}};
links.Network.prototype._createNode=function(a){var b=a.action?a.action:"update";if(b==="create"){var b=new links.Network.Node(a,this.images,this.groups,this.constants),e=a.id,c=e!==void 0?this._findNode(e):void 0;c!==void 0?this.nodes[c]=b:this.nodes.push(b);if(!b.isFixed())this.hasMovingNodes=!0}else if(b==="update"){e=a.id;if(e===void 0)throw"Cannot update a node without id";c=this._findNode(e);if(c!==void 0)this.nodes[c].setProperties(a);else if(b=new links.Network.Node(a,this.images,this.groups,
this.constants),this.nodes.push(b),!b.isFixed())this.hasMovingNodes=!0}else if(b==="delete"){e=a.id;if(e===void 0)throw"Cannot delete node without its id";c=this._findNode(e);if(c!==void 0)this.nodes.splice(c,1);else throw"Node with id "+e+" not found";}else throw"Unknown action "+b+". Choose 'create', 'update', or 'delete'.";};links.Network.prototype._findNode=function(a){for(var b=this.nodes,e=0,c=b.length;e<c;e++)if(b[e].id===a)return e};
links.Network.prototype.setLinks=function(a){if(google&&google.visualization&&google.visualization.DataTable&&a instanceof google.visualization.DataTable)a=links.Network.tableToArray(a);else if(!links.Network.isArray(a))return;this.linksTable=a;this.links=[];for(var b=this.hasMovingLinks=!1,e=a.length,c=0;c<e;c++){var f=a[c];if(f.from===void 0)throw"Column 'from' missing in table with links (row "+c+")";if(f.to===void 0)throw"Column 'to' missing in table with links (row "+c+")";if(f.timestamp!=void 0)this.hasTimestamps=
this.hasTimestamps||f.timestamp;f.value!=void 0&&(b=!0);this._createLink(f)}b&&this._updateValueRange(this.links)};
links.Network.prototype.addLinks=function(a){if(google&&google.visualization&&google.visualization.DataTable&&a instanceof google.visualization.DataTable)a=links.Network.tableToArray(a);else if(!links.Network.isArray(a))return;for(var b=!1,e=a.length,c=0;c<e;c++){var f=a[c];if(f.from===void 0)throw"Column 'from' missing in table with links (row "+c+")";if(f.to===void 0)throw"Column 'to' missing in table with links (row "+c+")";f.value!=void 0&&(b=!0);this._createLink(f)}b&&this._updateValueRange(this.links);
this.start()};links.Network.prototype._filterLinks=function(a){if(this.linksTable!=void 0){if(a!==void 0)for(var b=this.links,e=0;e<b.length;){var c=b[e].timestamp;c!==void 0&&c>a?b.splice(e,1):e++}b=this.linksTable;e=b.length;for(c=0;c<e;c++){var f=b[c];if(f.from===void 0)throw"Column 'from' missing in table with links (row "+c+")";if(f.to===void 0)throw"Column 'to' missing in table with links (row "+c+")";var g=f.timestamp?f.timestamp:void 0,h=!0;g!==void 0&&a!==void 0&&g>a&&(h=!1);h&&this._createLink(f)}this.start()}};
links.Network.prototype._createLink=function(a){var b=a.action?a.action:"create";if(b==="create"){var e=a.id,b=e!==void 0?this._findLink(e):void 0,e=new links.Network.Link(a,this,this.constants);b!==void 0?this.links[b]=e:this.links.push(e);if(e.isMoving())this.hasMovingLinks=!0}else if(b==="update"){e=a.id;if(e===void 0)throw"Cannot update a link without id";b=this._findLink(e);if(b!==void 0)e=this.links[b],e.setProperties(a);else if(e=new links.Network.Link(a,this,this.constants),this.links.push(e),
e.isMoving())this.hasMovingLinks=!0}else if(b==="delete"){e=a.id;if(e===void 0)throw"Cannot delete link without its id";b=this._findLink(e);if(b!==void 0)this.links.splice(b,1);else throw"Link with id "+e+" not found";}else throw"Unknown action "+b+". Choose 'create', 'update', or 'delete'.";};links.Network.prototype._updateNodeReferences=function(a,b){for(var e=[this.links,this.packages],c=0,f=e.length;c<f;c++)for(var g=e[c],h=0,i=g.length;h<i;h++){if(g.from===a)g.from=b;if(g.to===a)g.to=b}};
links.Network.prototype._findLink=function(a){for(var b=this.links,e=0,c=b.length;e<c;e++)if(b[e].id===a)return e};
links.Network.prototype.addPackages=function(a){if(google&&google.visualization&&google.visualization.DataTable&&a instanceof google.visualization.DataTable)a=links.Network.tableToArray(a);else if(!links.Network.isArray(a))return;for(var b=a.length,e=0;e<b;e++){var c=a[e];if(c.from===void 0)throw"Column 'from' missing in table with packages (row "+e+")";if(c.to===void 0)throw"Column 'to' missing in table with packages (row "+e+")";this._createPackage(c)}this._updateValueRange(this.packages);this.start()};
links.Network.prototype.setPackages=function(a){if(google&&google.visualization&&google.visualization.DataTable&&a instanceof google.visualization.DataTable)a=links.Network.tableToArray(a);else if(!links.Network.isArray(a))return;this.packagesTable=a;this.packages=[];for(var b=a.length,e=0;e<b;e++){var c=a[e];if(c.from===void 0)throw"Column 'from' missing in table with packages (row "+e+")";if(c.to===void 0)throw"Column 'to' missing in table with packages (row "+e+")";if(c.timestamp)this.hasTimestamps=
this.hasTimestamps||c.timestamp;this._createPackage(c)}this._updateValueRange(this.packages)};
links.Network.prototype._filterPackages=function(a){if(this.packagesTable!=void 0){this.packages=[];for(var b=this.packagesTable,e=b.length,c=0;c<e;c++){var f=b[c];if(f.from===void 0)throw"Column 'from' missing in table with packages (row "+c+")";if(f.to===void 0)throw"Column 'to' missing in table with packages (row "+c+")";var g=f.timestamp?f.timestamp:void 0,h=!0;g!==void 0&&a!==void 0&&g>a&&(h=!1);if(h===!0&&f.progress==void 0){var i=f.duration||this.constants.packages.duration,g=(a.getTime()-
g.getTime())/1E3;if(g<i){var j=f,f={};for(c in j)j.hasOwnProperty(c)&&(f[c]=j[c]);f.progress=g/i}else h=!1}h===!0&&this._createPackage(f)}this.start()}};
links.Network.prototype._createPackage=function(a){var b=a.action?a.action:"create";if(b==="create"){var e=a.id,b=e!==void 0?this._findPackage(e):void 0,a=new links.Network.Package(a,this,this.images,this.constants);b!==void 0?this.packages[b]=a:this.packages.push(a);if(a.isMoving())this.hasMovingPackages=!0}else if(b==="update"){e=a.id;if(e===void 0)throw"Cannot update a link without id";b=this._findPackage(e);if(b!==void 0)this.packages[b].setProperties(a);else if(a=new links.Network.Package(a,
this,this.images,this.constants),this.packages.push(a),a.isMoving())this.hasMovingPackages=!0}else if(b==="delete"){e=a.id;if(e===void 0)throw"Cannot delete package without its id";b=this._findPackage(e);if(b!==void 0)this.packages.splice(b,1);else throw"Package with id "+e+" not found";}else throw"Unknown action "+b+". Choose 'create', 'update', or 'delete'.";};links.Network.prototype._findPackage=function(a){for(var b=this.packages,e=0,c=b.length;e<c;e++)if(b[e].id===a)return e};
links.Network.prototype._getColumnNames=function(a){for(var b=a.getNumberOfColumns(),e={},c=0;c<b;c++){var f=a.getColumnLabel(c);e[f]=c}return e};links.Network.prototype._updateValueRange=function(a){for(var b=a.length,e=void 0,c=void 0,f=0;f<b;f++){var g=a[f].getValue();g!==void 0&&(e=e===void 0?g:Math.min(g,e),c=c===void 0?g:Math.max(g,c))}if(e!==void 0&&c!==void 0)for(f=0;f<b;f++)a[f].setValueRange(e,c)};
links.Network.prototype.setTimestamp=function(a){this._filterNodes(a);this._filterLinks(a);this._filterPackages(a)};
links.Network.prototype._getRange=function(){for(var a=void 0,b=void 0,e=[this.nodesTable,this.linksTable],c=0,f=e.length;c<f;c++){var g=e[c];if(g!==void 0)for(var h=0,i=g.length;h<i;h++){var j=g[h].timestamp;j&&(j instanceof Date&&(j=j.getTime()),a=a?Math.min(j,a):j,b=b?Math.max(j,b):j)}}if(this.packagesTable){e=this.packagesTable;c=0;for(f=e.length;c<f;c++)h=e[c],j=h.timestamp,g=h.progress,i=h.duration||this.constants.packages.duration,j instanceof Date&&(j=j.getTime()),j!=void 0&&(h=j,j=g?j:j+
i*1E3,a=a?Math.min(h,a):h,b=b?Math.max(j,b):j)}return{start:new Date(a),end:new Date(b)}};links.Network.prototype.animationStart=function(){this.slider&&this.slider.play()};links.Network.prototype.animationStop=function(){this.slider&&this.slider.stop()};links.Network.prototype.setAnimationFramerate=function(a){this.slider&&this.slider.setFramerate(a)};links.Network.prototype.setAnimationDuration=function(a){this.slider&&this.slider.setDuration(a)};
links.Network.prototype.setAnimationAcceleration=function(a){this.slider&&this.slider.setAcceleration(a)};links.Network.prototype.redraw=function(){this._setSize(this.width,this.height);this._redraw()};
links.Network.prototype._redraw=function(){var a=this.frame.canvas.getContext("2d");a.clearRect(0,0,this.frame.canvas.width,this.frame.canvas.height);a.save();a.translate(this.translation.x,this.translation.y);a.scale(this.scale,this.scale);this._drawLinks(a);this._drawNodes(a);this._drawPackages(a);this._drawSlider();a.restore()};
links.Network.prototype._setTranslation=function(a,b){if(this.translation===void 0)this.translation={x:0,y:0};if(a!==void 0)this.translation.x=a;if(b!==void 0)this.translation.y=b};links.Network.prototype._getTranslation=function(){return{x:this.translation.x,y:this.translation.y}};links.Network.prototype._setScale=function(a){this.scale=a};links.Network.prototype._getScale=function(){return this.scale};links.Network.prototype._xToCanvas=function(a){return(a-this.translation.x)/this.scale};
links.Network.prototype._canvasToX=function(a){return a*this.scale+this.translation.x};links.Network.prototype._yToCanvas=function(a){return(a-this.translation.y)/this.scale};links.Network.prototype._canvasToY=function(a){return a*this.scale+this.translation.y};links.Network.prototype._getNode=function(a){for(var b=0;b<this.nodes.length;b++)if(this.nodes[b].id==a)return this.nodes[b];return null};
links.Network.prototype._drawNodes=function(a){for(var b=this.nodes,e=[],c=0,f=b.length;c<f;c++)b[c].isSelected()?e.push(c):b[c].draw(a);c=0;for(f=e.length;c<f;c++)b[e[c]].draw(a)};links.Network.prototype._drawLinks=function(a){for(var b=this.links,e=0,c=b.length;e<c;e++)b[e].draw(a)};links.Network.prototype._drawPackages=function(a){for(var b=this.packages,e=0,c=b.length;e<c;e++)b[e].draw(a)};
links.Network.prototype._drawSlider=function(){if(this.hasTimestamps){var a=this.frame.slider;if(a===void 0){a=document.createElement("div");a.style.position="absolute";a.style.bottom="0px";a.style.left="0px";a.style.right="0px";a.style.backgroundColor="rgba(255, 255, 255, 0.7)";this.frame.slider=a;this.frame.slider.style.padding="10px";this.frame.appendChild(a);var b=this._getRange();this.slider=new links.Network.Slider(a);this.slider.setLoop(!1);this.slider.setRange(b.start,b.end);var e=this,a=
function(){var a=e.slider.getValue();e.setTimestamp(a);e.redraw()};this.slider.setOnChangeCallback(a);a()}}else if(a=this.frame.slider,a!==void 0)this.frame.removeChild(a),this.slider=this.frame.slider=void 0};
links.Network.prototype._reposition=function(){for(var a=this.constants.links.length*2,b=this.frame.canvas.clientWidth/2,e=this.frame.canvas.clientHeight/2,c=0;c<this.nodes.length;c++){var f=2*Math.PI*(c/this.nodes.length);if(!this.nodes[c].xFixed)this.nodes[c].x=b+a*Math.cos(f);if(!this.nodes[c].yFixed)this.nodes[c].y=e+a*Math.sin(f)}};
links.Network.prototype._doStabilize=function(){for(var a=0,b=this.constants.minVelocity,e=!1;!e&&a<this.constants.maxIterations;)this._calculateForces(),this._discreteStepNodes(),e=!this.isMoving(b),a++};
links.Network.prototype._calculateForces=function(){for(var a=this.nodes,b=this.links,e=this.frame.canvas.clientWidth/2,c=this.frame.canvas.clientHeight/2,f=0;f<a.length;f++){var g=e-a[f].x,h=c-a[f].y,g=Math.atan2(h,g),h=Math.cos(g)*0.01,g=Math.sin(g)*0.01;this.nodes[f]._setForce(h,g)}e=this.constants.nodes.distance;for(f=0;f<a.length;f++)for(c=f+1;c<this.nodes.length;c++){var g=a[c].x-a[f].x,h=a[c].y-a[f].y,i=Math.sqrt(g*g+h*h),g=Math.atan2(h,g),i=1/(1+Math.exp((i/e-1)*10)),h=Math.cos(g)*i,g=Math.sin(g)*
i;this.nodes[f]._addForce(-h,-g);this.nodes[c]._addForce(h,g)}a=0;for(f=b.length;a<f;a++)e=b[a],g=e.to.x-e.from.x,h=e.to.y-e.from.y,c=e.length,i=Math.sqrt(g*g+h*h),g=Math.atan2(h,g),c=e.stiffness*(c-i),h=Math.cos(g)*c,g=Math.sin(g)*c,e.from._addForce(-h,-g),e.to._addForce(h,g)};links.Network.prototype.isMoving=function(a){for(var b=this.nodes,e=0,c=b.length;e<c;e++)if(b[e].isMoving(a))return!0;return!1};
links.Network.prototype._discreteStepNodes=function(){for(var a=this.refreshRate/1E3,b=this.nodes,e=0,c=b.length;e<c;e++)b[e].discreteStep(a)};links.Network.prototype._discreteStepPackages=function(){for(var a=this.refreshRate/1E3,b=this.packages,e=0,c=b.length;e<c;e++)b[e].discreteStep(a)};
links.Network.prototype._deleteFinishedPackages=function(){for(var a=0,b=!1;a<this.packages.length;)this.packages[a].isFinished()?(this.packages.splice(a,1),a--):this.packages[a].isMoving()&&(b=!0),a++;this.hasMovingPackages=b};
links.Network.prototype.start=function(){if(this.hasMovingNodes)this._calculateForces(),this._discreteStepNodes(),this.hasMovingNodes=this.isMoving(this.constants.minVelocity);this.hasMovingPackages&&(this._discreteStepPackages(),this._deleteFinishedPackages());if(this.hasMovingNodes||this.hasMovingLinks||this.hasMovingPackages){if(!this.timer){var a=this;this.timer=window.setTimeout(function(){a.timer=void 0;a.start();a._redraw()},this.refreshRate)}}else this._redraw()};
links.Network.prototype.stop=function(){if(this.timer)window.clearInterval(this.timer),this.timer=void 0};links.Network.addEventListener=function(a,b,e,c){a.addEventListener?(c===void 0&&(c=!1),b==="mousewheel"&&navigator.userAgent.indexOf("Firefox")>=0&&(b="DOMMouseScroll"),a.addEventListener(b,e,c)):a.attachEvent("on"+b,e)};
links.Network.removeEventListener=function(a,b,e,c){a.removeEventListener?(c===void 0&&(c=!1),b==="mousewheel"&&navigator.userAgent.indexOf("Firefox")>=0&&(b="DOMMouseScroll"),a.removeEventListener(b,e,c)):a.detachEvent("on"+b,e)};links.Network.stopPropagation=function(a){if(!a)a=window.event;a.stopPropagation?a.stopPropagation():a.cancelBubble=!0};links.Network.preventDefault=function(a){if(!a)a=window.event;a.preventDefault?a.preventDefault():a.returnValue=!1};
links.Network._getAbsoluteLeft=function(a){for(var b=0;a!=null;)b+=a.offsetLeft,b-=a.scrollLeft,a=a.offsetParent;!document.body.scrollLeft&&window.pageXOffset&&(b-=window.pageXOffset);return b};links.Network._getAbsoluteTop=function(a){for(var b=0;a!=null;)b+=a.offsetTop,b-=a.scrollTop,a=a.offsetParent;!document.body.scrollTop&&window.pageYOffset&&(b-=window.pageYOffset);return b};
links.Network.Node=function(a,b,e,c){this.selected=!1;this.group=c.nodes.group;this.fontSize=c.nodes.fontSize;this.fontFace=c.nodes.fontFace;this.fontColor=c.nodes.fontColor;this.borderColor=c.nodes.borderColor;this.backgroundColor=c.nodes.backgroundColor;this.highlightColor=c.nodes.highlightColor;this.id=void 0;this.style=c.nodes.style;this.image=c.nodes.image;this.y=this.x=0;this.yFixed=this.xFixed=!1;this.radius=c.nodes.radius;this.radiusFixed=!1;this.radiusMin=c.nodes.radiusMin;this.radiusMax=
c.nodes.radiusMax;this.imagelist=b;this.grouplist=e;this.setProperties(a,c);this.mass=50;this.vy=this.vx=this.fy=this.fx=0;this.damping=0.5};
links.Network.Node.prototype.setProperties=function(a,b){if(a){if(a.id!=void 0)this.id=a.id;if(a.style!=void 0)this.style=a.style;if(a.text!=void 0)this.text=a.text;if(a.title!=void 0)this.title=a.title;if(a.image!=void 0)this.image=a.image;if(a.group!=void 0)this.group=a.group;if(a.x!=void 0)this.x=a.x;if(a.y!=void 0)this.y=a.y;if(a.radius!=void 0)this.radius=a.radius;if(a.value!=void 0)this.value=a.value;if(a.timestamp!=void 0)this.timestamp=a.timestamp;if(this.id===void 0)throw"Node must have an id";
if(this.group){var e=this.grouplist.get(this.group),c;for(c in e)e.hasOwnProperty(c)&&(this[c]=e[c])}if(this.image!=void 0)if(this.imagelist)this.imageObj=this.imagelist.load(this.image);else throw"No imagelist provided";this.xFixed=this.xFixed||a.x!=void 0;this.yFixed=this.yFixed||a.y!=void 0;this.radiusFixed=this.radiusFixed||a.radius!=void 0;if(this.style=="image")this.radiusMin=b.nodes.widthMin,this.radiusMax=b.nodes.widthMax;switch(this.style){case "database":this.draw=this._drawDatabase;break;
case "rect":this.draw=this._drawRect;break;case "circle":this.draw=this._drawCircle;break;case "image":this.draw=this._drawImage;break;case "text":this.draw=this._drawText;break;case "dot":this.draw=this._drawDot;break;case "square":this.draw=this._drawSquare;break;case "triangle":this.draw=this._drawTriangle;break;case "triangleDown":this.draw=this._drawTriangleDown;break;case "star":this.draw=this._drawStar;break;default:this.draw=this._drawText}this.height=this.width=void 0}};
links.Network.Node.prototype.select=function(){this.selected=!0;this._reset()};links.Network.Node.prototype.unselect=function(){this.selected=!1;this._reset()};links.Network.Node.prototype._reset=function(){this.height=this.width=void 0};links.Network.Node.prototype.getTitle=function(){return this.title};links.Network.Node.prototype._setForce=function(a,b){this.fx=a;this.fy=b};links.Network.Node.prototype._addForce=function(a,b){this.fx+=a;this.fy+=b};
links.Network.Node.prototype.discreteStep=function(a){this.xFixed||(this.vx+=(this.fx+-this.damping*this.vx)/this.mass/a,this.x+=this.vx/a);this.yFixed||(this.vy+=(this.fy+-this.damping*this.vy)/this.mass/a,this.y+=this.vy/a)};links.Network.Node.prototype.isFixed=function(){return this.xFixed&&this.yFixed};links.Network.Node.prototype.isMoving=function(a){return this.vx>a||this.vx<-a||this.vy>a||this.vy<-a||!this.xFixed&&Math.abs(this.fx)>0.0050||!this.yFixed&&Math.abs(this.fy)>0.0050};
links.Network.Node.prototype.isSelected=function(){return this.selected};links.Network.Node.prototype.getValue=function(){return this.value};links.Network.Node.prototype.getDistance=function(a,b){var e=this.x-a,c=this.y-b;return Math.sqrt(e*e+c*c)};links.Network.Node.prototype.setValueRange=function(a,b){if(!this.radiusFixed&&this.value!==void 0)this.radius=(this.value-a)*((this.radiusMax-this.radiusMin)/(b-a))+this.radiusMin};
links.Network.Node.prototype.draw=function(){throw"Draw method not initialized for node";};links.Network.Node.prototype.isOverlappingWith=function(a){return this.left<a.right&&this.left+this.width>a.left&&this.top<a.bottom&&this.top+this.height>a.top};
links.Network.Node.prototype._drawImage=function(a){if(this.value)var b=this.radius||this.imageObj.width,e=this.radius*(this.imageObj.height/this.imageObj.width)||this.imageObj.height;else b=this.imageObj.width,e=this.imageObj.height;this.left=this.x-b/2;this.top=this.y-e/2;this.width=b;this.height=e;this.imageObj?(a.drawImage(this.imageObj,this.left,this.top,b,e),b=this.y+e/2):b=this.y;this._text(a,this.text,this.x,b,void 0,"top")};
links.Network.Node.prototype._drawRect=function(a){if(!this.width){var b=this.getTextSize(a);this.width=b.width+10;this.height=b.height+10}this.left=this.x-this.width/2;this.top=this.y-this.height/2;a.strokeStyle=this.borderColor;a.fillStyle=this.selected?this.highlightColor:this.backgroundColor;a.lineWidth=this.selected?2:1;a.roundRect(this.left,this.top,this.width,this.height,this.radius);a.fill();a.stroke();this._text(a,this.text,this.x,this.y)};
links.Network.Node.prototype._drawDatabase=function(a){if(!this.width)this.height=this.width=this.getTextSize(a).width+10;this.left=this.x-this.width/2;this.top=this.y-this.height/2;a.strokeStyle=this.borderColor;a.fillStyle=this.selected?this.highlightColor:this.backgroundColor;a.lineWidth=this.selected?2:1;a.database(this.x-this.width/2,this.y-this.height*0.5,this.width,this.height);a.fill();a.stroke();this._text(a,this.text,this.x,this.y)};
links.Network.Node.prototype._drawCircle=function(a){if(!this.width){var b=this.getTextSize(a),b=Math.max(b.width,b.height)+10;this.radius=b/2;this.height=this.width=b}this.left=this.x-this.width/2;this.top=this.y-this.height/2;a.strokeStyle=this.borderColor;a.fillStyle=this.selected?this.highlightColor:this.backgroundColor;a.lineWidth=this.selected?2:1;a.circle(this.x,this.y,this.radius);a.fill();a.stroke();this._text(a,this.text,this.x,this.y)};
links.Network.Node.prototype._drawDot=function(a){this._drawShape(a,"circle")};links.Network.Node.prototype._drawTriangle=function(a){this._drawShape(a,"triangle")};links.Network.Node.prototype._drawTriangleDown=function(a){this._drawShape(a,"triangleDown")};links.Network.Node.prototype._drawSquare=function(a){this._drawShape(a,"square")};links.Network.Node.prototype._drawStar=function(a){this._drawShape(a,"star")};
links.Network.Node.prototype._drawShape=function(a,b){if(!this.width)this.height=this.width=2*this.radius;this.left=this.x-this.width/2;this.top=this.y-this.height/2;a.strokeStyle=this.borderColor;a.fillStyle=this.selected?this.highlightColor:this.backgroundColor;a.lineWidth=this.selected?2:1;a[b](this.x,this.y,this.radius);a.fill();a.stroke();this.text&&this._text(a,this.text,this.x,this.y+this.height/2,void 0,"top")};
links.Network.Node.prototype._drawText=function(a){if(!this.width){var b=this.getTextSize(a);this.width=b.width+10;this.height=b.height+10}this.left=this.x-this.width/2;this.top=this.y-this.height/2;this._text(a,this.text,this.x,this.y)};
links.Network.Node.prototype._text=function(a,b,e,c,f,g){if(b){a.font=(this.selected?"bold ":"")+this.fontSize+"px "+this.fontFace;a.fillStyle=this.fontColor||"black";a.textAlign=f||"center";a.textBaseline=g||"middle";b=b.split("\n");f=b.length;g=this.fontSize+4;c+=(1-f)/2*g;for(var h=0;h<f;h++)a.fillText(b[h],e,c),c+=g}};
links.Network.Node.prototype.getTextSize=function(a){if(this.text!=void 0){a.font=(this.selected?"bold ":"")+this.fontSize+"px "+this.fontFace;for(var b=this.text.split("\n"),e=(this.fontSize+4)*b.length,c=0,f=0,g=b.length;f<g;f++)c=Math.max(c,a.measureText(b[f]).width);return{width:c,height:e}}else return{width:0,height:0}};
links.Network.Link=function(a,b,e){if(!b)throw"No network provided";this.network=b;this.widthMin=e.links.widthMin;this.widthMax=e.links.widthMax;this.id=void 0;this.style=e.links.style;this.title=void 0;this.width=e.links.width;this.value=void 0;this.length=e.links.length;this.stiffness=void 0;this.color=e.links.color;this.timestamp=void 0;this.lengthFixed=this.widthFixed=!1;this.setProperties(a)};
links.Network.Link.prototype.setProperties=function(a){if(a){if(a.from!=void 0)this.from=this.network._getNode(a.from);if(a.to!=void 0)this.to=this.network._getNode(a.to);if(a.id!=void 0)this.id=a.id;if(a.style!=void 0)this.style=a.style;if(a.title!=void 0)this.title=a.title;if(a.width!=void 0)this.width=a.width;if(a.value!=void 0)this.value=a.value;if(a.length!=void 0)this.length=a.length;if(a.color!=void 0)this.color=a.color;if(a.timestamp!=void 0)this.timestamp=a.timestamp;if(!this.from)throw"Node with id "+
a.from+" not found";if(!this.to)throw"Node with id "+a.to+" not found";this.widthFixed=this.widthFixed||a.width!=void 0;this.lengthFixed=this.lengthFixed||a.length!=void 0;this.stiffness=1/this.length;if(this.style==="arrow")this.arrows=[0.5],this.animation=!1;else if(this.style==="moving-arrows"){this.arrows=[];for(a=0;a<3;a++)this.arrows.push(a/3);this.animation=!0}else this.style==="moving-dot"?(this.dot=0,this.animation=!0):this.animation=!1;switch(this.style){case "line":this.draw=this._drawLine;
break;case "arrow":this.draw=this._drawArrow;break;case "moving-arrows":this.draw=this._drawMovingArrows;break;case "moving-dot":this.draw=this._drawMovingDot;break;default:this.draw=this._drawLine}}};links.Network.Link.prototype.isMoving=function(){return this.animation};links.Network.Link.prototype.getTitle=function(){return this.title};links.Network.Link.prototype.getValue=function(){return this.value};
links.Network.Link.prototype.setValueRange=function(a,b){if(!this.widthFixed&&this.value!==void 0)this.width=(this.value-a)*((this.widthMax-this.widthMin)/(b-a))+this.widthMin};links.Network.Link.prototype.isLengthFixed=function(){return this.lengthFixed};links.Network.Link.prototype.getLength=function(){return this.length};links.Network.Link.prototype.setLength=function(a){if(!this.lengthFixed)this.length=a};
links.Network.Link.prototype.draw=function(){throw"Method draw not initialized in link";};links.Network.Link.prototype.isOverlappingWith=function(a){return links.Network._dist(this.from.x,this.from.y,this.to.x,this.to.y,a.left,a.top)<10};links.Network._dist=function(a,b,e,c,f,g){e-=a;c-=b;var h=((f-a)*e+(g-b)*c)/(e*e+c*c);h>1?h=1:h<0&&(h=0);a=a+h*e-f;b=b+h*c-g;return d=Math.sqrt(a*a+b*b)};
links.Network.Link.prototype._drawLine=function(a){a.strokeStyle=this.color;a.lineWidth=this.width;a.beginPath();a.moveTo(this.from.x,this.from.y);a.lineTo(this.to.x,this.to.y);a.stroke()};links.Network.Link.prototype._drawMovingArrows=function(a){this._drawArrow(a);for(var b in this.arrows)this.arrows.hasOwnProperty(b)&&(this.arrows[b]+=0.02,this.arrows[b]>1&&(this.arrows[b]=0))};
links.Network.Link.prototype._drawMovingDot=function(a){a.strokeStyle=this.color;a.fillStyle=this.color;a.lineWidth=this.width;a.beginPath();a.moveTo(this.from.x,this.from.y);a.lineTo(this.to.x,this.to.y);a.stroke();a.circle((1-this.dot)*this.from.x+this.dot*this.to.x,(1-this.dot)*this.from.y+this.dot*this.to.y,4+this.width*2);a.fill();this.dot+=0.05;if(this.dot>1)this.dot=0};
links.Network.Link.prototype._drawArrow=function(a){a.strokeStyle=this.color;a.fillStyle=this.color;a.lineWidth=this.width;a.beginPath();a.moveTo(this.from.x,this.from.y);a.lineTo(this.to.x,this.to.y);a.stroke();var b=Math.atan2(this.to.y-this.from.y,this.to.x-this.from.x),e=10+5*this.width,c;for(c in this.arrows)if(this.arrows.hasOwnProperty(c)){var f=this.arrows[c];a.arrow((1-f)*this.from.x+f*this.to.x,(1-f)*this.from.y+f*this.to.y,b,e);a.fill();a.stroke()}};
links.Network.Images=function(){this.images={};this.callback=void 0};links.Network.Images.prototype.setOnloadCallback=function(a){this.callback=a};links.Network.Images.prototype.load=function(a){var b=this.images[a];if(b==void 0){var e=this,b=new Image;this.images[a]=b;b.onload=function(){e.callback&&e.callback(this)};b.src=a}return b};
links.Network.Package=function(a,b,e,c){if(b==void 0)throw"No network provided";this.radiusMin=c.packages.radiusMin;this.radiusMax=c.packages.radiusMax;this.imagelist=e;this.network=b;this.title=this.to=this.from=this.id=void 0;this.style=c.packages.style;this.radius=c.packages.radius;this.color=c.packages.color;this.image=c.packages.image;this.value=void 0;this.progress=0;this.timestamp=void 0;this.duration=c.packages.duration;this.autoProgress=!0;this.radiusFixed=!1;this.setProperties(a,c)};
links.Network.Package.DEFAULT_DURATION=1;
links.Network.Package.prototype.setProperties=function(a,b){if(a){if(a.from!=void 0)this.from=this.network._getNode(a.from);if(a.to!=void 0)this.to=this.network._getNode(a.to);if(!this.from)throw"Node with id "+a.from+" not found";if(!this.to)throw"Node with id "+a.to+" not found";if(a.id!=void 0)this.id=a.id;if(a.title!=void 0)this.title=a.title;if(a.style!=void 0)this.style=a.style;if(a.radius!=void 0)this.radius=a.radius;if(a.value!=void 0)this.value=a.value;if(a.image!=void 0)this.image=a.image;
if(a.color!=void 0)this.color=a.color;if(a.progress!=void 0)this.progress=a.progress;if(a.timestamp!=void 0)this.timestamp=a.timestamp;if(a.duration!=void 0)this.duration=a.duration;this.radiusFixed=this.radiusFixed||a.radius!=void 0;this.autoProgress=this.autoProgress==!0?a.progress==void 0:!1;if(this.style=="image")this.radiusMin=b.packages.widthMin,this.radiusMax=b.packages.widthMax;if(this.progress<0)this.progress=0;if(this.progress>1)this.progress=1;if(this.image!=void 0)if(this.imagelist)this.imageObj=
this.imagelist.load(this.image);else throw"No imagelist provided";switch(this.style){case "dot":this.draw=this._drawDot;break;case "square":this.draw=this._drawSquare;break;case "triangle":this.draw=this._drawTriangle;break;case "triangleDown":this.draw=this._drawTriangleDown;break;case "star":this.draw=this._drawStar;break;case "image":this.draw=this._drawImage;break;default:this.draw=this._drawDot}}};links.Network.Package.prototype.setProgress=function(a){this.progress=a;this.autoProgress=!1};
links.Network.Package.prototype.isFinished=function(){return this.autoProgress==!0&&this.progress>=1};links.Network.Package.prototype.isMoving=function(){return this.autoProgress||this.isFinished()};links.Network.Package.prototype.discreteStep=function(a){if(this.autoProgress==!0&&(this.progress+=parseFloat(a)/this.duration,this.progress>1))this.progress=1};links.Network.Package.prototype.draw=function(){throw"Draw method not initialized for package";};
links.Network.Package.prototype.isOverlappingWith=function(a){var b=Math.max(this.radius,10),e=this._getPosition();return e.x-b<a.right&&e.x+b>a.left&&e.y-b<a.bottom&&e.y+b>a.top};links.Network.Package.prototype._getPosition=function(){return{x:(1-this.progress)*this.from.x+this.progress*this.to.x,y:(1-this.progress)*this.from.y+this.progress*this.to.y}};links.Network.Package.prototype.getTitle=function(){return this.title};links.Network.Package.prototype.getValue=function(){return this.value};
links.Network.Package.prototype.getDistance=function(a,b){var e=this._getPosition(),c=e.x-a,e=e.y-b;return Math.sqrt(c*c+e*e)};links.Network.Package.prototype.setValueRange=function(a,b){if(!this.radiusFixed&&this.value!==void 0)this.radius=(this.value-a)*((this.radiusMax-this.radiusMin)/(b-a))+this.radiusMin};links.Network.Package.prototype._drawDot=function(a){this._drawShape(a,"circle")};links.Network.Package.prototype._drawTriangle=function(a){this._drawShape(a,"triangle")};
links.Network.Package.prototype._drawTriangleDown=function(a){this._drawShape(a,"triangleDown")};links.Network.Package.prototype._drawSquare=function(a){this._drawShape(a,"square")};links.Network.Package.prototype._drawStar=function(a){this._drawShape(a,"star")};links.Network.Package.prototype._drawShape=function(a,b){a.fillStyle=this.color;var e=this._getPosition();a[b](e.x,e.y,this.radius);a.fill()};
links.Network.Package.prototype._drawImage=function(a){if(this.imageObj){if(this.value)var b=this.radius||this.imageObj.width,e=this.radius*(this.imageObj.height/this.imageObj.width)||this.imageObj.height;else b=this.imageObj.width,e=this.imageObj.height;var c=this._getPosition();a.drawImage(this.imageObj,c.x-b/2,c.y-e/2,b,e)}else console.log("image still loading...")};links.Network.Groups=function(){this.clear();this.defaultIndex=0};
links.Network.Groups.DEFAULT=[{borderColor:"#2B7CE9",backgroundColor:"#97C2FC",highlightColor:"#D2E5FF"},{borderColor:"#FFA500",backgroundColor:"#FFFF00",highlightColor:"#FFFFA3"},{borderColor:"#FA0A10",backgroundColor:"#FB7E81",highlightColor:"#FFAFB1"},{borderColor:"#41A906",backgroundColor:"#7BE141",highlightColor:"#A1EC76"},{borderColor:"#E129F0",backgroundColor:"#EB7DF4",highlightColor:"#F0B3F5"},{borderColor:"#7C29F0",backgroundColor:"#AD85E4",highlightColor:"#D3BDF0"},{borderColor:"#C37F00",
backgroundColor:"#FFA807",highlightColor:"#FFCA66"},{borderColor:"#4220FB",backgroundColor:"#6E6EFD",highlightColor:"#9B9BFD"},{borderColor:"#FD5A77",backgroundColor:"#FFC0CB",highlightColor:"#FFD1D9"},{borderColor:"#4AD63A",backgroundColor:"#C2FABC",highlightColor:"#E6FFE3"}];links.Network.Groups.prototype.clear=function(){this.groups={};this.groups.length=function(){var a=0,b;for(b in this)this.hasOwnProperty(b)&&a++;return a}};
links.Network.Groups.prototype.get=function(a){var b=this.groups[a];if(b==void 0){var e=this.defaultIndex%links.Network.Groups.DEFAULT.length;this.defaultIndex++;b={};b.borderColor=links.Network.Groups.DEFAULT[e].borderColor;b.backgroundColor=links.Network.Groups.DEFAULT[e].backgroundColor;b.highlightColor=links.Network.Groups.DEFAULT[e].highlightColor;this.groups[a]=b}return b};links.Network.Groups.prototype.add=function(a,b){return this.groups[a]=b};
links.Network.isArray=function(a){return a instanceof Array?!0:Object.prototype.toString.call(a)==="[object Array]"};
links.Network.Slider=function(a){if(a===void 0)throw"Error: No container element defined";this.container=a;this.frame=document.createElement("DIV");this.frame.style.width="100%";this.frame.style.position="relative";this.title=document.createElement("DIV");this.title.style.margin="2px";this.title.style.marginBottom="5px";this.title.innerHTML="";this.container.appendChild(this.title);this.frame.prev=document.createElement("INPUT");this.frame.prev.type="BUTTON";this.frame.prev.value="Prev";this.frame.appendChild(this.frame.prev);
this.frame.play=document.createElement("INPUT");this.frame.play.type="BUTTON";this.frame.play.value="Play";this.frame.appendChild(this.frame.play);this.frame.next=document.createElement("INPUT");this.frame.next.type="BUTTON";this.frame.next.value="Next";this.frame.appendChild(this.frame.next);this.frame.bar=document.createElement("INPUT");this.frame.bar.type="BUTTON";this.frame.bar.style.position="absolute";this.frame.bar.style.border="1px solid red";this.frame.bar.style.width="100px";this.frame.bar.style.height=
"6px";this.frame.bar.style.borderRadius="2px";this.frame.bar.style.MozBorderRadius="2px";this.frame.bar.style.border="1px solid #7F7F7F";this.frame.bar.style.backgroundColor="#E5E5E5";this.frame.appendChild(this.frame.bar);this.frame.slide=document.createElement("INPUT");this.frame.slide.type="BUTTON";this.frame.slide.style.margin="0px";this.frame.slide.value=" ";this.frame.slide.style.position="relative";this.frame.slide.style.left="-100px";this.frame.appendChild(this.frame.slide);var b=this;this.frame.slide.onmousedown=
function(a){b._onMouseDown(a)};this.frame.prev.onclick=function(a){b.prev(a)};this.frame.play.onclick=function(a){b.togglePlay(a)};this.frame.next.onclick=function(a){b.next(a)};this.container.appendChild(this.frame);this.playTimeout=this.onChangeCallback=void 0;this.framerate=20;this.duration=10;this.doLoop=!0;this.step=this.value=this.end=this.start=0;this.rangeIsDate=!1;this.redraw()};links.Network.Slider.prototype._updateStep=function(){this.step=(this.end-this.start)/(this.duration*this.framerate)};
links.Network.Slider.prototype.prev=function(){this._setValue(this.value-this.step)};links.Network.Slider.prototype.next=function(){this._setValue(this.value+this.step)};
links.Network.Slider.prototype.playNext=function(){var a=new Date;if(!this.leftButtonDown)if(this.value+this.step<this.end)this._setValue(this.value+this.step);else if(this.doLoop)this._setValue(this.start);else{this._setValue(this.end);this.stop();return}var a=Math.max(1E3/this.framerate-(new Date-a),0),b=this;this.playTimeout=setTimeout(function(){b.playNext()},a)};links.Network.Slider.prototype.togglePlay=function(){this.playTimeout===void 0?this.play():this.stop()};
links.Network.Slider.prototype.play=function(){this.frame.play.value="Stop";this.playNext()};links.Network.Slider.prototype.stop=function(){this.frame.play.value="Play";clearInterval(this.playTimeout);this.playTimeout=void 0};links.Network.Slider.prototype.setOnChangeCallback=function(a){this.onChangeCallback=a};links.Network.Slider.prototype.setFramerate=function(a){this.framerate=a;this._updateStep()};links.Network.Slider.prototype.getFramerate=function(){return this.framerate};
links.Network.Slider.prototype.setDuration=function(a){this.duration=a;this._updateStep()};links.Network.Slider.prototype.setAcceleration=function(a){this.duration=(this.end-this.start)/1E3/a;this._updateStep()};links.Network.Slider.prototype.setLoop=function(a){this.doLoop=a};links.Network.Slider.prototype.getLoop=function(){return this.doLoop};links.Network.Slider.prototype.onChange=function(){if(this.onChangeCallback!==void 0)this.onChangeCallback()};
links.Network.Slider.prototype.redraw=function(){var a=this.frame.clientWidth-this.frame.prev.clientWidth-this.frame.play.clientWidth-this.frame.next.clientWidth-30;this.frame.bar.style.top=this.frame.clientHeight/2-this.frame.bar.offsetHeight/2+"px";this.frame.bar.style.width=a+"px";this.frame.slide.title=this.getValue();this.frame.slide.style.left=this._valueToLeft(this.value)+"px";this.title.innerHTML=this.getValue()};
links.Network.Slider.prototype.setRange=function(a,b){a===void 0||a===null||a===NaN?(this.start=0,this.rangeIsDate=!1):a instanceof Date?(this.start=a.getTime(),this.rangeIsDate=!0):(this.start=a,this.rangeIsDate=!1);this.end=b===void 0||b===null||b===NaN?this.start instanceof Date?new Date(this.start):this.start:b instanceof Date?b.getTime():b;this.value=this.start;this._updateStep();this.redraw()};
links.Network.Slider.prototype._setValue=function(a){this.value=this._limitValue(a);this.redraw();this.onChange()};links.Network.Slider.prototype.getValue=function(){return this.rangeIsDate?new Date(this.value):this.value};links.Network.Slider.prototype.offset=3;links.Network.Slider.prototype._leftToValue=function(a){var b=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10;return this._limitValue((a-this.offset)/b*(this.end-this.start)+this.start)};
links.Network.Slider.prototype._valueToLeft=function(a){var b=parseFloat(this.frame.bar.style.width)-this.frame.slide.clientWidth-10;return(this.end>this.start?(a-this.start)/(this.end-this.start)*b:0)+this.offset};links.Network.Slider.prototype._limitValue=function(a){if(a<this.start)a=this.start;if(a>this.end)a=this.end;return a};
links.Network.Slider.prototype._onMouseDown=function(a){if(this.leftButtonDown=a.which?a.which===1:a.button===1){this.startClientX=a.clientX;this.startSlideX=parseFloat(this.frame.slide.style.left);this.frame.style.cursor="move";var b=this;this.onmousemove=function(a){b._onMouseMove(a)};this.onmouseup=function(a){b._onMouseUp(a)};links.Network.addEventListener(document,"mousemove",this.onmousemove);links.Network.addEventListener(document,"mouseup",this.onmouseup);links.Network.preventDefault(a)}};
links.Network.Slider.prototype._onMouseMove=function(a){this._setValue(this._leftToValue(this.startSlideX+(a.clientX-this.startClientX)));links.Network.preventDefault(a)};links.Network.Slider.prototype._onMouseUp=function(a){this.frame.style.cursor="auto";this.leftButtonDown=!1;links.Network.removeEventListener(document,"mousemove",this.onmousemove);links.Network.removeEventListener(document,"mouseup",this.onmouseup);links.Network.preventDefault(a)};
links.Network.Popup=function(a,b,e,c){this.container=a?a:document.body;this.y=this.x=0;this.padding=5;b!==void 0&&e!==void 0&&this.setPosition(b,e);c!==void 0&&this.setText(c);this.frame=document.createElement("div");a=this.frame.style;a.position="absolute";a.visibility="hidden";a.border="1px solid #666";a.color="black";a.padding=this.padding+"px";a.backgroundColor="#FFFFC6";a.borderRadius="3px";a.MozBorderRadius="3px";a.WebkitBorderRadius="3px";a.boxShadow="3px 3px 4px #BFBFBF";a.whiteSpace="nowrap";
this.container.appendChild(this.frame)};links.Network.Popup.prototype.setPosition=function(a,b){this.x=parseInt(a);this.y=parseInt(b)};links.Network.Popup.prototype.setText=function(a){this.frame.innerHTML=a};
links.Network.Popup.prototype.show=function(a){a===void 0&&(a=!0);if(a){var b=this.frame.clientHeight,a=this.frame.clientWidth,e=this.frame.parentNode.clientHeight,c=this.frame.parentNode.clientWidth,f=this.y-b;f+b+this.padding>e&&(f=e-b-this.padding);if(f<this.padding)f=this.padding;b=this.x;b+a+this.padding>c&&(b=c-a-this.padding);if(b<this.padding)b=this.padding;this.frame.style.left=b+"px";this.frame.style.top=f+"px";this.frame.style.visibility="visible"}else this.hide()};
links.Network.Popup.prototype.hide=function(){this.frame.style.visibility="hidden"};
links.events=links.events||{listeners:[],indexOf:function(a){for(var b=this.listeners,e=0,c=this.listeners.length;e<c;e++){var f=b[e];if(f&&f.object==a)return e}return-1},addListener:function(a,b,e){var c=this.listeners[this.indexOf(a)];c||(c={object:a,events:{}},this.listeners.push(c));a=c.events[b];a||(a=[],c.events[b]=a);a.indexOf(e)==-1&&a.push(e)},removeListener:function(a,b,e){var a=this.indexOf(a),c=this.listeners[a];if(c){var f=c.events[b];f&&(a=f.indexOf(e),a!=-1&&f.splice(a,1),f.length==
0&&delete c.events[b]);e=0;c=c.events;for(b in c)c.hasOwnProperty(b)&&e++;e==0&&delete this.listeners[a]}},removeAllListeners:function(){this.listeners=[]},trigger:function(a,b,e){if(a=this.listeners[this.indexOf(a)])if(b=a.events[b])for(var a=0,c=b.length;a<c;a++)b[a](e)}};CanvasRenderingContext2D.prototype.circle=function(a,b,e){this.beginPath();this.arc(a,b,e,0,2*Math.PI,!1)};CanvasRenderingContext2D.prototype.square=function(a,b,e){this.beginPath();this.rect(a-e,b-e,e*2,e*2)};
CanvasRenderingContext2D.prototype.triangle=function(a,b,e){this.beginPath();var c=e*2,e=c/2,f=Math.sqrt(3)/6*c,c=Math.sqrt(c*c-e*e);this.moveTo(a,b-(c-f));this.lineTo(a+e,b+f);this.lineTo(a-e,b+f);this.lineTo(a,b-(c-f));this.closePath()};CanvasRenderingContext2D.prototype.triangleDown=function(a,b,e){this.beginPath();var c=e*2,e=c/2,f=Math.sqrt(3)/6*c,c=Math.sqrt(c*c-e*e);this.moveTo(a,b+(c-f));this.lineTo(a+e,b-f);this.lineTo(a-e,b-f);this.lineTo(a,b+(c-f));this.closePath()};
CanvasRenderingContext2D.prototype.star=function(a,b,e){this.beginPath();for(var c=0;c<10;c++){var f=c%2===0?e*1.3:e*0.5;this.lineTo(a+f*Math.sin(c*2*Math.PI/10),b-f*Math.cos(c*2*Math.PI/10))}this.closePath()};
CanvasRenderingContext2D.prototype.roundRect=function(a,b,e,c,f){var g=Math.PI/180;e-2*f<0&&(f=e/2);c-2*f<0&&(f=c/2);this.beginPath();this.moveTo(a+f,b);this.lineTo(a+e-f,b);this.arc(a+e-f,b+f,f,g*270,g*360,!1);this.lineTo(a+e,b+c-f);this.arc(a+e-f,b+c-f,f,g*0,g*90,!1);this.lineTo(a+f,b+c);this.arc(a+f,b+c-f,f,g*90,g*180,!1);this.lineTo(a,b+f);this.arc(a+f,b+f,f,g*180,g*270,!1)};
CanvasRenderingContext2D.prototype.ellipse=function(a,b,e,c){var f=e/2*0.5522848,g=c/2*0.5522848,h=a+e,i=b+c,e=a+e/2,c=b+c/2;this.beginPath();this.moveTo(a,c);this.bezierCurveTo(a,c-g,e-f,b,e,b);this.bezierCurveTo(e+f,b,h,c-g,h,c);this.bezierCurveTo(h,c+g,e+f,i,e,i);this.bezierCurveTo(e-f,i,a,c+g,a,c)};
CanvasRenderingContext2D.prototype.database=function(a,b,e,c){var f=c*(1/3),g=e/2*0.5522848,h=f/2*0.5522848,i=a+e,j=b+f,e=a+e/2,k=b+f/2,f=b+(c-f/2),c=b+c;this.beginPath();this.moveTo(i,k);this.bezierCurveTo(i,k+h,e+g,j,e,j);this.bezierCurveTo(e-g,j,a,k+h,a,k);this.bezierCurveTo(a,k-h,e-g,b,e,b);this.bezierCurveTo(e+g,b,i,k-h,i,k);this.lineTo(i,f);this.bezierCurveTo(i,f+h,e+g,c,e,c);this.bezierCurveTo(e-g,c,a,f+h,a,f);this.lineTo(a,k)};
CanvasRenderingContext2D.prototype.arrow=function(a,b,e,c){var f=a+c*0.5*Math.cos(e),g=b+c*0.5*Math.sin(e),h=a-c*0.5*Math.cos(e),i=b-c*0.5*Math.sin(e);a-=c*0.4*Math.cos(e);b-=c*0.4*Math.sin(e);var j=h+c/3*Math.cos(e+0.5*Math.PI),k=i+c/3*Math.sin(e+0.5*Math.PI);h+=c/3*Math.cos(e-0.5*Math.PI);e=i+c/3*Math.sin(e-0.5*Math.PI);this.beginPath();this.moveTo(f,g);this.lineTo(j,k);this.lineTo(a,b);this.lineTo(h,e);this.closePath()};
