/*

 Licensed under the Apache License, Version 2.0 (the "License"); you may not
 use this file except in compliance with the License. You may obtain a copy 
 of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 License for the specific language governing permissions and limitations under
 the License.

 Copyright (c) 2011-2012 Almende B.V.

 @author 	Jos de Jong, <jos@almende.org>
 @date    2012-05-01
*/
typeof links==="undefined"&&(links={});typeof google==="undefined"&&(google=void 0);
links.Timeline=function(a){this.dom={};this.conversion={};this.eventParams={};this.groups=[];this.groupIndexes={};this.items=[];this.selection=void 0;this.listeners={};this.size={actualHeight:0,axis:{characterMajorHeight:0,characterMajorWidth:0,characterMinorHeight:0,characterMinorWidth:0,height:0,labelMajorTop:0,labelMinorTop:0,line:0,lineMajorWidth:0,lineMinorHeight:0,lineMinorTop:0,lineMinorWidth:0,top:0},contentHeight:0,contentLeft:0,contentWidth:0,dataChanged:!1,frameHeight:0,frameWidth:0,groupsLeft:0,
groupsWidth:0,items:{top:0}};this.dom.container=a;this.options={width:"100%",height:"auto",minHeight:0,autoHeight:!0,eventMargin:10,eventMarginAxis:20,dragAreaWidth:10,min:void 0,max:void 0,intervalMin:10,intervalMax:31536E10,moveable:!0,zoomable:!0,selectable:!0,editable:!1,snapEvents:!0,groupChangeable:!0,showCurrentTime:!0,showCustomTime:!1,showMajorLabels:!0,showNavigation:!1,showButtonAdd:!0,groupsOnRight:!1,axisOnTop:!1,stackEvents:!0,animate:!0,animateZoom:!0,style:"box"};this.clientTimeOffset=
0;for(a=this.dom;a.container.hasChildNodes();)a.container.removeChild(a.container.firstChild);this.step=new links.Timeline.StepDate;this.data=[];this.firstDraw=!0;this.setVisibleChartRange(void 0,void 0,!1);this.redrawFrame();if(!Array.prototype.indexOf)Array.prototype.indexOf=function(a){for(var c=0;c<this.length;c++)if(this[c]==a)return c;return-1};this.trigger("ready")};
links.Timeline.prototype.draw=function(a,b){this.setOptions(b);this.setData(a);b&&b.start&&b.end?this.setVisibleChartRange(b.start,b.end):this.firstDraw&&this.setVisibleChartRangeAuto();this.firstDraw=!1};links.Timeline.prototype.setOptions=function(a){if(a)for(var b in a)a.hasOwnProperty(b)&&(this.options[b]=a[b]);this.options.autoHeight=this.options.height==="auto"};
links.Timeline.prototype.setData=function(a){this.unselectItem();a||(a=[]);this.items=[];this.data=a;var b=this.items;this.setGroups(a);if(google&&google.visualization&&a instanceof google.visualization.DataTable)for(var c=a.getNumberOfColumns()>3,d=0,e=a.getNumberOfRows();d<e;d++)b.push(this.createItem({start:a.getValue(d,0),end:a.getValue(d,1),content:a.getValue(d,2),group:c?a.getValue(d,3):void 0}));else if(links.Timeline.isArray(a)){d=0;for(e=a.length;d<e;d++)c=this.createItem(a[d]),b.push(c)}else throw"Unknown data type. DataTable or Array expected.";
this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(!1);this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.setGroups=function(a){this.deleteGroups();if(google&&google.visualization&&a instanceof google.visualization.DataTable){if(a.getNumberOfColumns()>3)for(var a=a.getDistinctValues(3),b=0,c=a.length;b<c;b++)this.addGroup(a[b])}else if(links.Timeline.isArray(a)){b=0;for(c=a.length;b<c;b++){var d=a[b].group;d&&this.addGroup(d)}}else throw"Unknown data type. DataTable or Array expected.";};links.Timeline.prototype.getData=function(){return this.data};
links.Timeline.prototype.updateData=function(a,b){var c=this.data;if(google&&google.visualization&&c instanceof google.visualization.DataTable){var d=a+1-c.getNumberOfRows();d>0&&c.addRows(d);b.start&&c.setValue(a,0,b.start);b.end&&c.setValue(a,1,b.end);b.content&&c.setValue(a,2,b.content);b.group&&c.getNumberOfColumns()>3&&c.setValue(a,3,b.group)}else if(links.Timeline.isArray(c)){d=c[a];d==void 0&&(d={},c[a]=d);if(b.start)d.start=b.start;if(b.end)d.end=b.end;if(b.content)d.content=b.content;if(b.group)d.group=
b.group}else throw"Cannot update data, unknown type of data";};links.Timeline.prototype.getItemIndex=function(a){for(var b=this.dom,c=this.items,d=void 0;a.parentNode&&a.parentNode!==b.items.frame;)a=a.parentNode;if(a.parentNode===b.items.frame)for(var b=0,e=c.length;b<e;b++)if(c[b].dom===a){d=b;break}return d};
links.Timeline.prototype.setSize=function(a,b){if(a)this.options.width=a,this.dom.frame.style.width=a;if(b&&(this.options.height=b,this.options.autoHeight=this.options.height==="auto",b!=="auto"))this.dom.frame.style.height=b;this.recalcSize();this.stackEvents(!1);this.redrawFrame()};
links.Timeline.prototype.setVisibleChartRange=function(a,b,c){a==void 0&&(a=new Date,a.setDate(a.getDate()-3));b==void 0&&(b=new Date,b.setDate(a.getDate()+4));b.valueOf()<=a.valueOf()&&(b=new Date(a),b.setDate(b.getDate()+7));var d=this.options.min?this.options.min.valueOf():void 0;d&&a.valueOf()<d&&(a=new Date(d));(d=this.options.max?this.options.max.valueOf():void 0)&&b.valueOf()>d&&(b=new Date(d));this.applyRange(a,b);c==void 0||c==!0?(this.recalcSize(),this.stackEvents(!1),this.redrawFrame()):
this.recalcConversion()};
links.Timeline.prototype.setVisibleChartRangeAuto=function(){var a=this.items;startMin=void 0;endMax=void 0;for(var b=0,c=a.length;b<c;b++){var d=a[b],e=d.start?d.start.valueOf():void 0,d=d.end?d.end.valueOf():e;startMin=startMin!==void 0&&e!==void 0?Math.min(startMin,e):e;endMax=endMax!==void 0&&d!==void 0?Math.max(endMax,d):d}startMin!==void 0&&endMax!==void 0?(a=endMax-startMin,startMin-=a*0.05,endMax+=a*0.05,this.setVisibleChartRange(new Date(startMin),new Date(endMax))):this.setVisibleChartRange(void 0,
void 0)};links.Timeline.prototype.setVisibleChartRangeNow=function(){var a=new Date,b=this.end.getTime()-this.start.getTime(),a=new Date(a.getTime()-b/2),b=new Date(a.getTime()+b);this.setVisibleChartRange(a,b)};links.Timeline.prototype.getVisibleChartRange=function(){return{start:new Date(this.start),end:new Date(this.end)}};
links.Timeline.prototype.redrawFrame=function(){var a=this.dom,b=this.options,c=this.size;if(!a.frame)a.frame=document.createElement("DIV"),a.frame.className="timeline-frame",a.frame.style.position="relative",a.frame.style.overflow="hidden",a.container.appendChild(a.frame);a.frame.style.height=b.autoHeight?c.frameHeight+"px":b.height||"100%";a.frame.style.width=b.width||"100%";this.redrawContent();this.redrawGroups();this.redrawCurrentTime();this.redrawCustomTime();this.redrawNavigation()};
links.Timeline.prototype.redrawContent=function(){var a=this.dom,b=this.size;if(!a.content){a.content=document.createElement("DIV");a.content.style.position="relative";a.content.style.overflow="hidden";a.frame.appendChild(a.content);var c=document.createElement("DIV");c.style.position="absolute";c.style.left="0px";c.style.top="0px";c.style.height="100%";c.style.width="0px";a.content.appendChild(c);a.contentTimelines=c;var c=this.eventParams,d=this;if(!c.onMouseDown)c.onMouseDown=function(a){d.onMouseDown(a)},
links.Timeline.addEventListener(a.content,"mousedown",c.onMouseDown);if(!c.onTouchStart)c.onTouchStart=function(a){d.onTouchStart(a)},links.Timeline.addEventListener(a.content,"touchstart",c.onTouchStart);if(!c.onMouseWheel)c.onMouseWheel=function(a){d.onMouseWheel(a)},links.Timeline.addEventListener(a.content,"mousewheel",c.onMouseWheel);if(!c.onDblClick)c.onDblClick=function(a){d.onDblClick(a)},links.Timeline.addEventListener(a.content,"dblclick",c.onDblClick)}a.content.style.left=b.contentLeft+
"px";a.content.style.top="0px";a.content.style.width=b.contentWidth+"px";a.content.style.height=b.frameHeight+"px";this.redrawAxis();this.redrawItems();this.redrawDeleteButton();this.redrawDragAreas()};
links.Timeline.prototype.redrawAxis=function(){var a=this.dom,b=this.options,c=this.size,d=this.step,e=a.axis;if(!e)e={},a.axis=e;if(c.axis.properties===void 0)c.axis.properties={};if(e.minorTexts===void 0)e.minorTexts=[];if(e.minorLines===void 0)e.minorLines=[];if(e.majorTexts===void 0)e.majorTexts=[];if(e.majorLines===void 0)e.majorLines=[];if(!e.frame)e.frame=document.createElement("DIV"),e.frame.style.position="absolute",e.frame.style.left="0px",e.frame.style.top="0px",a.content.appendChild(e.frame);
a.content.removeChild(e.frame);e.frame.style.width=c.contentWidth+"px";e.frame.style.height=c.axis.height+"px";var f=this.screenToTime(0),g=this.screenToTime(c.contentWidth),h=c.contentWidth;this.minimumStep=this.screenToTime(c.axis.characterMinorWidth*6).valueOf()-this.screenToTime(0).valueOf();d.setRange(f,g,this.minimumStep);this.redrawAxisCharacters();this.redrawAxisStartOverwriting();d.start();for(f=void 0;!d.end();)h=this.timeToScreen(d.getCurrent()),g=d.isMajor(),this.redrawAxisMinorText(h,
d.getLabelMinor()),g&&b.showMajorLabels?(h>0&&(f===void 0&&(f=h),this.redrawAxisMajorText(h,d.getLabelMajor())),this.redrawAxisMajorLine(h)):this.redrawAxisMinorLine(h),d.next();b.showMajorLabels&&(b=this.screenToTime(0),d=this.step.getLabelMajor(b),h=d.length*c.axis.characterMajorWidth+10,(f===void 0||h<f)&&this.redrawAxisMajorText(0,d,b));this.redrawAxisHorizontal();this.redrawAxisEndOverwriting();a.content.insertBefore(e.frame,a.content.firstChild)};
links.Timeline.prototype.redrawAxisCharacters=function(){var a=this.dom.axis;if(!a.characterMinor){var b=document.createTextNode("0"),c=document.createElement("DIV");c.className="timeline-axis-text timeline-axis-text-minor";c.appendChild(b);c.style.position="absolute";c.style.visibility="hidden";c.style.paddingLeft="0px";c.style.paddingRight="0px";a.frame.appendChild(c);a.characterMinor=c}if(!a.characterMajor)b=document.createTextNode("0"),c=document.createElement("DIV"),c.className="timeline-axis-text timeline-axis-text-major",
c.appendChild(b),c.style.position="absolute",c.style.visibility="hidden",c.style.paddingLeft="0px",c.style.paddingRight="0px",a.frame.appendChild(c),a.characterMajor=c};links.Timeline.prototype.redrawAxisStartOverwriting=function(){var a=this.size.axis.properties;a.minorTextNum=0;a.minorLineNum=0;a.majorTextNum=0;a.majorLineNum=0};
links.Timeline.prototype.redrawAxisEndOverwriting=function(){for(var a=this.dom,b=this.size.axis.properties,c=this.dom.axis.frame,d=a.axis.minorTexts,e=b.minorTextNum;d.length>e;)c.removeChild(d[e]),d.splice(e,1);d=a.axis.minorLines;for(e=b.minorLineNum;d.length>e;)c.removeChild(d[e]),d.splice(e,1);d=a.axis.majorTexts;for(e=b.majorTextNum;d.length>e;)c.removeChild(d[e]),d.splice(e,1);a=a.axis.majorLines;for(e=b.majorLineNum;a.length>e;)c.removeChild(a[e]),a.splice(e,1)};
links.Timeline.prototype.redrawAxisHorizontal=function(){var a=this.dom.axis,b=this.size;if(!a.backgroundLine){var c=document.createElement("DIV");c.className="timeline-axis";c.style.position="absolute";c.style.left="0px";c.style.width="100%";c.style.border="none";a.frame.insertBefore(c,a.frame.firstChild);a.backgroundLine=c}a.backgroundLine.style.top=b.axis.top+"px";a.backgroundLine.style.height=b.axis.height+"px";a.line?(c=a.frame.removeChild(a.line),a.frame.appendChild(c)):(c=document.createElement("DIV"),
c.className="timeline-axis",c.style.position="absolute",c.style.left="0px",c.style.width="100%",c.style.height="0px",a.frame.appendChild(c),a.line=c);a.line.style.top=b.axis.line+"px"};
links.Timeline.prototype.redrawAxisMinorText=function(a,b){var c=this.size,d=this.dom,e=c.axis.properties,f=d.axis.frame,d=d.axis.minorTexts,g=e.minorTextNum;if(g<d.length)g=d[g];else{var h=document.createTextNode(""),g=document.createElement("DIV");g.appendChild(h);g.className="timeline-axis-text timeline-axis-text-minor";g.style.position="absolute";f.appendChild(g);d.push(g)}g.childNodes[0].nodeValue=b;g.style.left=a+"px";g.style.top=c.axis.labelMinorTop+"px";e.minorTextNum++};
links.Timeline.prototype.redrawAxisMinorLine=function(a){var b=this.size.axis,c=this.dom,d=b.properties,e=c.axis.frame,c=c.axis.minorLines,f=d.minorLineNum;f<c.length?f=c[f]:(f=document.createElement("DIV"),f.className="timeline-axis-grid timeline-axis-grid-minor",f.style.position="absolute",f.style.width="0px",e.appendChild(f),c.push(f));f.style.top=b.lineMinorTop+"px";f.style.height=b.lineMinorHeight+"px";f.style.left=a-b.lineMinorWidth/2+"px";d.minorLineNum++};
links.Timeline.prototype.redrawAxisMajorText=function(a,b){var c=this.size,d=c.axis.properties,e=this.dom.axis.frame,f=this.dom.axis.majorTexts,g=d.majorTextNum;if(g<f.length)g=f[g];else{var h=document.createTextNode(b),g=document.createElement("DIV");g.className="timeline-axis-text timeline-axis-text-major";g.appendChild(h);g.style.position="absolute";g.style.top="0px";e.appendChild(g);f.push(g)}g.childNodes[0].nodeValue=b;g.style.top=c.axis.labelMajorTop+"px";g.style.left=a+"px";d.majorTextNum++};
links.Timeline.prototype.redrawAxisMajorLine=function(a){var b=this.size,c=b.axis.properties,d=this.size.axis,e=this.dom.axis.frame,f=this.dom.axis.majorLines,g=c.majorLineNum;g<f.length?g=f[g]:(g=document.createElement("DIV"),g.className="timeline-axis-grid timeline-axis-grid-major",g.style.position="absolute",g.style.top="0px",g.style.width="0px",e.appendChild(g),f.push(g));g.style.left=a-d.lineMajorWidth/2+"px";g.style.height=b.frameHeight+"px";c.majorLineNum++};
links.Timeline.prototype.redrawItems=function(){var a=this.dom,b=this.options,c=b.box&&b.box.align?b.box.align:void 0;size=this.size;contentWidth=size.contentWidth;items=this.items;if(!a.items)a.items={};var d=a.items.frame;if(!d)d=document.createElement("DIV"),d.style.position="relative",a.content.appendChild(d),a.items.frame=d;d.style.left="0px";d.style.top=size.items.top+"px";d.style.height=size.frameHeight-size.axis.height+"px";var e=a.items.ranges;if(!e)e=[],a.items.ranges=e;var f=a.items.boxes;
if(!f)f=[],a.items.boxes=f;var g=a.items.dots;if(!g)g=[],a.items.dots=g;a.content.removeChild(d);if(size.dataChanged){for(var h=e.length,l=f.length,o=g.length,m=0,r=0,q=0,n=0,p=items.length;n<p;n++){var j=items[n];switch(j.type){case "range":if(m<h){var k=e[m];k.firstChild.innerHTML=j.content;k.style.display="";j.dom=k;m++}else k=this.createEventRange(j.content),e[m]=k,d.appendChild(k),j.dom=k,m++,h++;break;case "box":r<l?(k=f[r],k.firstChild.innerHTML=j.content,k.style.display="",j.dom=k,r++):(k=
this.createEventBox(j.content),f[r]=k,d.appendChild(k),d.insertBefore(k.line,d.firstChild),d.appendChild(k.dot),j.dom=k,r++,l++);break;case "dot":q<o?(k=g[q],k.firstChild.innerHTML=j.content,k.style.display="",j.dom=k,q++):(k=this.createEventDot(j.content),g[q]=k,d.appendChild(k),j.dom=k,q++,o++)}}for(n=m;n<h;n++)d.removeChild(e[n]);e.splice(m,h-m);for(n=r;n<l;n++)p=f[n],d.removeChild(p.line),d.removeChild(p.dot),d.removeChild(p);f.splice(r,l-r);for(n=q;n<o;n++)d.removeChild(g[n]);g.splice(q,o-q)}n=
0;for(p=items.length;n<p;n++)switch(j=items[n],k=j.dom,j.type){case "range":f=this.timeToScreen(j.start);g=this.timeToScreen(j.end);f<-contentWidth&&(f=-contentWidth);g>2*contentWidth&&(g=2*contentWidth);if((l=g>-contentWidth&&f<2*contentWidth)||size.dataChanged){if(j.hidden)j.hidden=!1,k.style.display="";k.style.top=j.top+"px";k.style.left=f+"px";k.style.width=Math.max(g-f,1)+"px"}else if(!j.hidden)k.style.display="none",j.hidden=!0;break;case "box":f=this.timeToScreen(j.start);o=b.axisOnTop;g=size.axis.top;
if((l=f+j.width/2>-contentWidth&&f-j.width/2<2*contentWidth)||size.dataChanged){if(j.hidden)j.hidden=!1,k.style.display="",k.line.style.display="",k.dot.style.display="";k.style.top=j.top+"px";k.style.left=c=="right"?f-j.width+"px":c=="left"?f+"px":f-j.width/2+"px";l=k.line;l.style.left=f-j.lineWidth/2+"px";o?(l.style.top="0px",l.style.height=Math.max(j.top,0)+"px"):(l.style.top=j.top+j.height+"px",l.style.height=Math.max(g-j.top-j.height,0)+"px");k=k.dot;k.style.left=f-j.dotWidth/2+"px";k.style.top=
g-j.dotHeight/2+"px"}else if(!j.hidden)k.style.display="none",k.line.style.display="none",k.dot.style.display="none",j.hidden=!0;break;case "dot":if(f=this.timeToScreen(j.start),(l=f+j.width>-contentWidth&&f<2*contentWidth)||size.dataChanged){if(j.hidden)j.hidden=!1,k.style.display="";k.style.top=j.top+"px";k.style.left=f-j.dotWidth/2+"px";k.content.style.marginLeft=1.5*j.dotWidth+"px";k.dot.style.top=(j.height-j.dotHeight)/2+"px"}else if(!j.hidden)k.style.display="none",j.hidden=!0}if(this.selection)j=
this.selection.item,d.removeChild(j),d.appendChild(j);a.content.appendChild(d)};
links.Timeline.prototype.createEventBox=function(a){var b=document.createElement("DIV");b.style.position="absolute";b.style.left="0px";b.style.top="0px";b.className="timeline-event timeline-event-box";var c=document.createElement("DIV");c.className="timeline-event-content";c.innerHTML=a;b.appendChild(c);a=document.createElement("DIV");a.style.position="absolute";a.style.width="0px";a.className="timeline-event timeline-event-line";b.line=a;a=document.createElement("DIV");a.style.position="absolute";
a.style.width="0px";a.style.height="0px";a.className="timeline-event timeline-event-dot";b.dot=a;return b};
links.Timeline.prototype.createEventDot=function(a){var b=document.createElement("DIV");b.style.position="absolute";var c=document.createElement("DIV");c.className="timeline-event-content";c.innerHTML=a;b.appendChild(c);a=document.createElement("DIV");a.style.position="absolute";a.className="timeline-event timeline-event-dot";a.style.width="0px";a.style.height="0px";b.appendChild(a);b.content=c;b.dot=a;return b};
links.Timeline.prototype.createEventRange=function(a){var b=document.createElement("DIV");b.style.position="absolute";b.className="timeline-event timeline-event-range";var c=document.createElement("DIV");c.className="timeline-event-content";c.innerHTML=a;b.appendChild(c);return b};
links.Timeline.prototype.redrawGroups=function(){var a=this.dom,b=this.options,c=this.size,d=this.groups;if(a.groups===void 0)a.groups={};var e=a.groups.labels;if(!e)e=[],a.groups.labels=e;var f=a.groups.labelLines;if(!f)f=[],a.groups.labelLines=f;var g=a.groups.itemLines;if(!g)g=[],a.groups.itemLines=g;var h=a.groups.frame;if(!h)h=document.createElement("DIV"),h.className="timeline-groups-axis",h.style.position="absolute",h.style.overflow="hidden",h.style.top="0px",h.style.height="100%",a.frame.appendChild(h),
a.groups.frame=h;h.style.left=c.groupsLeft+"px";h.style.width=b.groupsWidth!==void 0?b.groupsWidth:c.groupsWidth+"px";h.style.display=d.length==0?"none":"";if(c.dataChanged){for(var l=e.length,o=d.length,m=0,r=Math.min(l,o);m<r;m++){var q=d[m],n=e[m];n.innerHTML=q.content;n.style.display=""}for(m=l;m<o;m++){q=d[m];n=document.createElement("DIV");n.className="timeline-groups-text";n.style.position="absolute";if(b.groupsWidth===void 0)n.style.whiteSpace="nowrap";n.innerHTML=q.content;h.appendChild(n);
e[m]=n;var p=document.createElement("DIV");p.className="timeline-axis-grid timeline-axis-grid-minor";p.style.position="absolute";p.style.left="0px";p.style.width="100%";p.style.height="0px";p.style.borderTopStyle="solid";h.appendChild(p);f[m]=p;var j=document.createElement("DIV");j.className="timeline-axis-grid timeline-axis-grid-minor";j.style.position="absolute";j.style.left="0px";j.style.width="100%";j.style.height="0px";j.style.borderTopStyle="solid";a.content.insertBefore(j,a.content.firstChild);
g[m]=j}for(m=o;m<l;m++)n=e[m],p=f[m],j=g[m],h.removeChild(n),h.removeChild(p),a.content.removeChild(j);e.splice(o,l-o);f.splice(o,l-o);g.splice(o,l-o);h.style.borderStyle=b.groupsOnRight?"none none none solid":"none solid none none"}m=0;for(r=d.length;m<r;m++)q=d[m],n=e[m],p=f[m],j=g[m],n.style.top=q.labelTop+"px",p.style.top=q.lineTop+"px",j.style.top=q.lineTop+"px",j.style.width=c.contentWidth+"px";if(!a.groups.background)b=document.createElement("DIV"),b.className="timeline-axis",b.style.position=
"absolute",b.style.left="0px",b.style.width="100%",b.style.border="none",h.appendChild(b),a.groups.background=b;a.groups.background.style.top=c.axis.top+"px";a.groups.background.style.height=c.axis.height+"px";if(!a.groups.line)b=document.createElement("DIV"),b.className="timeline-axis",b.style.position="absolute",b.style.left="0px",b.style.width="100%",b.style.height="0px",h.appendChild(b),a.groups.line=b;a.groups.line.style.top=c.axis.line+"px"};
links.Timeline.prototype.redrawCurrentTime=function(){var a=this.dom,b=this.size;if(this.options.showCurrentTime){if(!a.currentTime){var c=document.createElement("DIV");c.className="timeline-currenttime";c.style.position="absolute";c.style.top="0px";c.style.height="100%";a.contentTimelines.appendChild(c);a.currentTime=c}var c=new Date((new Date).getTime()+this.clientTimeOffset),d=this.timeToScreen(c);a.currentTime.style.display=d>-b.contentWidth&&d<2*b.contentWidth?"":"none";a.currentTime.style.left=
d+"px";a.currentTime.title="Current time: "+c;this.currentTimeTimer!=void 0&&(clearTimeout(this.currentTimeTimer),delete this.currentTimeTimer);var e=this,a=1/this.conversion.factor/2;a<30&&(a=30);this.currentTimeTimer=setTimeout(function(){e.redrawCurrentTime()},a)}else a.currentTime&&(a.contentTimelines.removeChild(a.currentTime),delete a.currentTime)};
links.Timeline.prototype.redrawCustomTime=function(){var a=this.dom,b=this.size;if(this.options.showCustomTime){if(!a.customTime){var c=document.createElement("DIV");c.className="timeline-customtime";c.style.position="absolute";c.style.top="0px";c.style.height="100%";var d=document.createElement("DIV");d.style.position="relative";d.style.top="0px";d.style.left="-10px";d.style.height="100%";d.style.width="20px";c.appendChild(d);a.contentTimelines.appendChild(c);a.customTime=c;this.customTime=new Date}c=
this.timeToScreen(this.customTime);a.customTime.style.display=c>-b.contentWidth&&c<2*b.contentWidth?"":"none";a.customTime.style.left=c+"px";a.customTime.title="Time: "+this.customTime}else a.customTime&&(a.contentTimelines.removeChild(a.customTime),delete a.customTime)};
links.Timeline.prototype.redrawDeleteButton=function(){var a=this.dom,b=this.size,c=a.items.frame;if(this.options.editable){var d=a.items.deleteButton;if(!d)d=document.createElement("DIV"),d.className="timeline-navigation-delete",d.style.position="absolute",c.appendChild(d),a.items.deleteButton=d;if(this.selection){var a=this.items[this.selection.index],e,f=a.top;switch(a.type){case "range":e=this.timeToScreen(a.end);break;case "box":e=this.timeToScreen(a.start)+a.width/2;break;case "dot":e=this.timeToScreen(a.start)+
a.width}e<-b.contentWidth&&(e=-b.contentWidth);e>2*b.contentWidth&&(e=2*b.contentWidth);d.style.left=e+"px";d.style.top=f+"px";d.style.display="";c.removeChild(d);c.appendChild(d)}else d.style.display="none"}};
links.Timeline.prototype.redrawDragAreas=function(){var a=this.options,b=this.dom,c=this.dom.items.frame;if(a.editable){var d=b.items.dragLeft;if(!d)d=document.createElement("DIV"),d.style.width=a.dragAreaWidth+"px",d.style.position="absolute",d.style.cursor="w-resize",c.appendChild(d),b.items.dragLeft=d;var e=b.items.dragRight;if(!e)e=document.createElement("DIV"),e.style.width=a.dragAreaWidth+"px",e.style.position="absolute",e.style.cursor="e-resize",c.appendChild(e),b.items.dragRight=e;if(this.selection){var f=
this.items[this.selection.index];if(f.type=="range"){var b=this.timeToScreen(f.start),g=this.timeToScreen(f.end),h=f.top,f=f.height;d.style.left=b+"px";d.style.top=h+"px";d.style.height=f+"px";d.style.display="";c.removeChild(d);c.appendChild(d);e.style.left=g-a.dragAreaWidth+"px";e.style.top=h+"px";e.style.height=f+"px";e.style.display="";c.removeChild(e);c.appendChild(e)}}else d.style.display="none",e.style.display="none"}};
links.Timeline.prototype.redrawNavigation=function(){var a=this,b=this.options,c=this.dom,d=c.frame,e=c.navBar;if(!e){if(b.editable||b.showNavigation)e=document.createElement("DIV"),e.style.position="absolute",e.className="timeline-navigation",b.groupsOnRight?e.style.left="10px":e.style.right="10px",b.axisOnTop?e.style.bottom="10px":e.style.top="10px",c.navBar=e,d.appendChild(e);if(b.editable&&b.showButtonAdd)e.addButton=document.createElement("DIV"),e.addButton.className="timeline-navigation-new",
e.addButton.title="Create new event",links.Timeline.addEventListener(e.addButton,"mousedown",function(c){links.Timeline.preventDefault(c);links.Timeline.stopPropagation(c);var d=a.size.contentWidth,e=d/2,c=a.screenToTime(e-d/10),d=a.screenToTime(e+d/10);b.snapEvents&&(a.step.snap(c),a.step.snap(d));a.addItem({start:c,end:d,content:"New",group:a.groups.length?a.groups[0].content:void 0});c=a.items.length-1;a.selectItem(c);a.applyAdd=!0;a.trigger("add");a.applyAdd||a.deleteItem(c);a.redrawDeleteButton();
a.redrawDragAreas()}),e.appendChild(e.addButton);if(b.editable&&b.showButtonAdd&&b.showNavigation)e.addButton.style.borderRightWidth="1px",e.addButton.style.borderRightStyle="solid";if(b.showNavigation)e.zoomInButton=document.createElement("DIV"),e.zoomInButton.className="timeline-navigation-zoom-in",e.zoomInButton.title="Zoom in",links.Timeline.addEventListener(e.zoomInButton,"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.zoom(0.4);a.trigger("rangechange");
a.trigger("rangechanged")}),e.appendChild(e.zoomInButton),e.zoomOutButton=document.createElement("DIV"),e.zoomOutButton.className="timeline-navigation-zoom-out",e.zoomOutButton.title="Zoom out",links.Timeline.addEventListener(e.zoomOutButton,"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.zoom(-0.4);a.trigger("rangechange");a.trigger("rangechanged")}),e.appendChild(e.zoomOutButton),e.moveLeftButton=document.createElement("DIV"),e.moveLeftButton.className=
"timeline-navigation-move-left",e.moveLeftButton.title="Move left",links.Timeline.addEventListener(e.moveLeftButton,"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.move(-0.2);a.trigger("rangechange");a.trigger("rangechanged")}),e.appendChild(e.moveLeftButton),e.moveRightButton=document.createElement("DIV"),e.moveRightButton.className="timeline-navigation-move-right",e.moveRightButton.title="Move right",links.Timeline.addEventListener(e.moveRightButton,
"mousedown",function(b){links.Timeline.preventDefault(b);links.Timeline.stopPropagation(b);a.move(0.2);a.trigger("rangechange");a.trigger("rangechanged")}),e.appendChild(e.moveRightButton)}};links.Timeline.prototype.setCurrentTime=function(a){var b=new Date;this.clientTimeOffset=a.getTime()-b.getTime();this.redrawCurrentTime()};links.Timeline.prototype.getCurrentTime=function(){return new Date((new Date).getTime()+this.clientTimeOffset)};
links.Timeline.prototype.setCustomTime=function(a){this.customTime=new Date(a);this.redrawCustomTime()};links.Timeline.prototype.getCustomTime=function(){return new Date(this.customTime)};links.Timeline.prototype.setScale=function(a,b){this.step.setScale(a,b);this.redrawFrame()};links.Timeline.prototype.setAutoScale=function(a){this.step.setAutoScale(a);this.redrawFrame()};links.Timeline.prototype.redraw=function(){this.setData(this.data)};
links.Timeline.prototype.checkResize=function(){this.recalcSize()&&this.redrawFrame()};links.Timeline.filterImageUrls=function(a,b){for(var c=a.firstChild;c;){if(c.tagName=="IMG"){var d=c.src;b.indexOf(d)==-1&&b.push(d)}links.Timeline.filterImageUrls(c,b);c=c.nextSibling}};
links.Timeline.prototype.recalcSize=function(){var a=!1,b=this;size=this.size;options=this.options;axisOnTop=options.axisOnTop;dom=this.dom;axis=dom.axis;groups=this.groups;labels=dom.groups.labels;items=this.items;groupsWidth=size.groupsWidth;characterMinorWidth=axis.characterMinor?axis.characterMinor.clientWidth:0;characterMinorHeight=axis.characterMinor?axis.characterMinor.clientHeight:0;characterMajorWidth=axis.characterMajor?axis.characterMajor.clientWidth:0;characterMajorHeight=axis.characterMajor?
axis.characterMajor.clientHeight:0;axisHeight=characterMinorHeight+(options.showMajorLabels?characterMajorHeight:0);actualHeight=size.actualHeight||axisHeight;if(size.dataChanged){for(var c=[],d=0,e=items.length;d<e;d++){var f=items[d],g=f.dom;g&&links.Timeline.filterImageUrls(g,c)}if(c.length)for(d=0;d<c.length;d++)links.imageloader.load(c[d],function(){b.redraw()},!1)}if(size.dataChanged){d=groupsWidth=0;for(e=labels.length;d<e;d++)c=groups[d],c.width=labels[d].clientWidth,c.height=labels[d].clientHeight,
c.labelHeight=c.height,groupsWidth=Math.max(groupsWidth,c.width);d=0;for(e=items.length;d<e;d++){var f=items[d],g=f.dom,c=f.group,h=g?g.clientWidth:0,l=g?g.clientHeight:0,a=(a=a||f.width!=h)||f.height!=l;f.width=h;f.height=l;switch(f.type){case "box":f.dotHeight=g.dot.offsetHeight;f.dotWidth=g.dot.offsetWidth;f.lineWidth=g.line.offsetWidth;break;case "dot":f.dotHeight=g.dot.offsetHeight,f.dotWidth=g.dot.offsetWidth,f.contentHeight=g.content.offsetHeight}if(c)c.height=c.height?Math.max(c.height,f.height):
f.height}actualHeight=axisHeight+2*options.eventMarginAxis;d=0;for(e=groups.length;d<e;d++)actualHeight+=groups[d].height+options.eventMargin}if(groups.length==0&&options.autoHeight){g=c=0;if(this.animation&&this.animation.finalItems){f=this.animation.finalItems;if((h=f[0])&&h.top)c=h.top,g=h.top+h.height;d=1;for(e=f.length;d<e;d++)h=f[d],c=Math.min(c,h.top),g=Math.max(g,h.top+h.height)}else{if((f=items[0])&&f.top)c=f.top,g=f.top+f.height;d=1;for(e=items.length;d<e;d++)f=items[d],f.top&&(c=Math.min(c,
f.top),g=Math.max(g,f.top+f.height))}actualHeight=g-c+2*options.eventMarginAxis+axisHeight;if(size.actualHeight!=actualHeight&&options.autoHeight&&!options.axisOnTop)if(c=actualHeight-size.actualHeight,this.animation&&this.animation.finalItems){f=this.animation.finalItems;d=0;for(e=f.length;d<e;d++)f[d].top+=c,f[d].item.top+=c}else{d=0;for(e=items.length;d<e;d++)items[d].top+=c}}var g=dom.frame?dom.frame.offsetWidth:0,h=Math.max(options.autoHeight?actualHeight:dom.frame?dom.frame.clientHeight:0,options.minHeight),
l=axisOnTop?0:h-axisHeight,o=axisOnTop?axisHeight:l,m=axisOnTop?axisHeight:0,r=Math.max(h-axisHeight,0);options.groupsWidth!==void 0&&(groupsWidth=dom.groups.frame?dom.groups.frame.clientWidth:0);var q=options.groupsOnRight?g-groupsWidth:0;if(size.dataChanged){a=options.eventMargin;f=axisOnTop?options.eventMarginAxis+a/2:r-options.eventMarginAxis+a/2;d=0;for(e=groups.length;d<e;d++)c=groups[d],axisOnTop?(c.top=f,c.labelTop=f+axisHeight+(c.height-c.labelHeight)/2,c.lineTop=f+axisHeight+c.height+a/
2,f+=c.height+a):(f-=c.height+a,c.top=f,c.labelTop=f+(c.height-c.labelHeight)/2,c.lineTop=f-a/2);d=0;for(e=items.length;d<e;d++)if(f=items[d],c=f.group)f.top=c.top;a=!0}a=(a=(a=a||size.groupsWidth!==groupsWidth)||size.groupsLeft!==q)||size.actualHeight!==actualHeight;size.groupsWidth=groupsWidth;size.groupsLeft=q;size.actualHeight=actualHeight;a=(a=a||size.frameWidth!==g)||size.frameHeight!==h;size.frameWidth=g;size.frameHeight=h;a=a||size.groupsWidth!==groupsWidth;size.groupsWidth=groupsWidth;size.contentLeft=
options.groupsOnRight?0:groupsWidth;size.contentWidth=Math.max(g-groupsWidth,0);size.contentHeight=r;a=(a=(a=(a=a||size.axis.top!==l)||size.axis.line!==o)||size.axis.height!==axisHeight)||size.items.top!==m;size.axis.top=l;size.axis.line=o;size.axis.height=axisHeight;size.axis.labelMajorTop=options.axisOnTop?0:o+characterMinorHeight;size.axis.labelMinorTop=options.axisOnTop?options.showMajorLabels?characterMajorHeight:0:o;size.axis.lineMinorTop=options.axisOnTop?size.axis.labelMinorTop:0;size.axis.lineMinorHeight=
options.showMajorLabels?h-characterMajorHeight:h;size.axis.lineMinorWidth=dom.axis.minorLines.length?dom.axis.minorLines[0].offsetWidth:1;size.axis.lineMajorWidth=dom.axis.majorLines.length?dom.axis.majorLines[0].offsetWidth:1;size.items.top=m;a=(a=(a=(a=a||size.axis.characterMinorWidth!==characterMinorWidth)||size.axis.characterMinorHeight!==characterMinorHeight)||size.axis.characterMajorWidth!==characterMajorWidth)||size.axis.characterMajorHeight!==characterMajorHeight;size.axis.characterMinorWidth=
characterMinorWidth;size.axis.characterMinorHeight=characterMinorHeight;size.axis.characterMajorWidth=characterMajorWidth;size.axis.characterMajorHeight=characterMajorHeight;this.recalcConversion();return a};links.Timeline.prototype.recalcConversion=function(){this.conversion.offset=parseFloat(this.start.valueOf());this.conversion.factor=parseFloat(this.size.contentWidth)/parseFloat(this.end.valueOf()-this.start.valueOf())};
links.Timeline.prototype.screenToTime=function(a){var b=this.conversion;return new Date(parseFloat(a)/b.factor+b.offset)};links.Timeline.prototype.timeToScreen=function(a){var b=this.conversion;return(a.valueOf()-b.offset)*b.factor};
links.Timeline.prototype.onTouchStart=function(a){var b=this.eventParams,c=this;if(!b.touchDown){b.touchDown=!0;b.zoomed=!1;this.onMouseDown(a);if(!b.onTouchMove)b.onTouchMove=function(a){c.onTouchMove(a)},links.Timeline.addEventListener(document,"touchmove",b.onTouchMove);if(!b.onTouchEnd)b.onTouchEnd=function(a){c.onTouchEnd(a)},links.Timeline.addEventListener(document,"touchend",b.onTouchEnd)}};
links.Timeline.prototype.onTouchMove=function(a){var b=this.eventParams;if(a.scale&&a.scale!==1)b.zoomed=!0;if(b.zoomed){if(this.options.zoomable){b.zoomed=!0;var c=b.end.valueOf()-b.start.valueOf(),d=c/a.scale-c,c=new Date(parseInt(b.start.valueOf()-d/2)),b=new Date(parseInt(b.end.valueOf()+d/2));this.setVisibleChartRange(c,b);timeline.trigger("rangechange");links.Timeline.preventDefault(a)}}else this.onMouseMove(a)};
links.Timeline.prototype.onTouchEnd=function(a){var b=this.eventParams;b.touchDown=!1;b.zoomed&&timeline.trigger("rangechanged");b.onTouchMove&&(links.Timeline.removeEventListener(document,"touchmove",b.onTouchMove),delete b.onTouchMove);b.onTouchEnd&&(links.Timeline.removeEventListener(document,"touchend",b.onTouchEnd),delete b.onTouchEnd);this.onMouseUp(a)};
links.Timeline.prototype.onMouseDown=function(a){var a=a||window.event,b=this.eventParams,c=this.options,d=this.dom;if((a.which?a.which==1:a.button==1)||b.touchDown){this.recalcSize();b.touchDown?(b.mouseX=a.targetTouches[0].clientX,b.mouseY=a.targetTouches[0].clientY):(b.mouseX=a.clientX,b.mouseY=a.clientY);if(b.mouseX===void 0)b.mouseX=0;if(b.mouseY===void 0)b.mouseY=0;b.frameLeft=links.Timeline.getAbsoluteLeft(this.dom.content);b.frameTop=links.Timeline.getAbsoluteTop(this.dom.content);b.previousLeft=
0;b.previousOffset=0;b.moved=!1;b.start=new Date(this.start);b.end=new Date(this.end);b.target=links.Timeline.getTarget(a);b.itemDragLeft=b.target===this.dom.items.dragLeft;b.itemDragRight=b.target===this.dom.items.dragRight;b.itemIndex=b.itemDragLeft||b.itemDragRight?this.selection?this.selection.index:void 0:this.getItemIndex(b.target);b.customTime=b.target===d.customTime||b.target.parentNode===d.customTime?this.customTime:void 0;b.addItem=c.editable&&a.ctrlKey;if(b.addItem){var e=b.mouseY-b.frameTop,
d=this.screenToTime(b.mouseX-b.frameLeft);c.snapEvents&&this.step.snap(d);var f=new Date(d),e=this.getGroupFromHeight(e);this.addItem({start:d,end:f,content:"New",group:e.content});b.itemIndex=this.items.length-1;this.selectItem(b.itemIndex);b.itemDragRight=!0}b.editItem=c.editable?this.isSelected(b.itemIndex):void 0;b.editItem?(c=this.items[b.itemIndex],b.itemStart=c.start,b.itemEnd=c.end,b.itemType=c.type,b.itemType=="range"?(b.itemLeft=this.timeToScreen(c.start),b.itemRight=this.timeToScreen(c.end)):
b.itemLeft=this.timeToScreen(c.start)):this.dom.frame.style.cursor="move";if(!b.touchDown){var g=this;if(!b.onMouseMove)b.onMouseMove=function(a){g.onMouseMove(a)},links.Timeline.addEventListener(document,"mousemove",b.onMouseMove);if(!b.onMouseUp)b.onMouseUp=function(a){g.onMouseUp(a)},links.Timeline.addEventListener(document,"mouseup",b.onMouseUp);links.Timeline.preventDefault(a)}}};
links.Timeline.prototype.onMouseMove=function(a){var a=a||window.event,b=this.eventParams,c=this.size,d=this.dom,e=this.options;if(b.touchDown)f=a.targetTouches[0].clientX,g=a.targetTouches[0].clientY;else var f=a.clientX,g=a.clientY;f===void 0&&(f=0);g===void 0&&(g=0);if(b.mouseX===void 0)b.mouseX=f;if(b.mouseY===void 0)b.mouseY=g;f=parseFloat(f)-b.mouseX;parseFloat(g);b.moved=!0;if(b.customTime)this.customTime=this.screenToTime(this.timeToScreen(b.customTime)+f),this.redrawCustomTime(),this.trigger("timechange");
else if(b.editItem){var d=this.items[b.itemIndex],h;if(b.itemDragLeft){if(c=b.itemLeft+f,h=b.itemRight,d.start=this.screenToTime(c),e.snapEvents&&(this.step.snap(d.start),c=this.timeToScreen(d.start)),c>h)c=h,d.start=this.screenToTime(c)}else if(b.itemDragRight){if(c=b.itemLeft,h=b.itemRight+f,d.end=this.screenToTime(h),e.snapEvents&&(this.step.snap(d.end),h=this.timeToScreen(d.end)),h<c)h=c,d.end=this.screenToTime(h)}else if(c=b.itemLeft+f,d.start=this.screenToTime(c),e.snapEvents&&(this.step.snap(d.start),
c=this.timeToScreen(d.start)),d.end)h=c+(b.itemRight-b.itemLeft),d.end=this.screenToTime(h);this.repositionItem(d,c,h);if(this.groups.length==0)this.stackEvents(e.animate),e.animate||this.redrawFrame();else if(e.groupsChangeable&&(b=this.getGroupFromHeight(g-b.frameTop),d.group!==b))this.changeItem(this.items.indexOf(d),{group:b.content}),d.top=b.top,this.repositionItem(d);this.redrawDeleteButton();this.redrawDragAreas()}else if(e.moveable)e=b.end.valueOf()-b.start.valueOf(),g=Math.round(parseFloat(-f)/
c.contentWidth*e),f=new Date(b.start.valueOf()+g),this.applyRange(f,new Date(b.end.valueOf()+g)),(f=this.start.valueOf()-f.valueOf())&&(g+=f),this.recalcConversion(),f=b.previousLeft||0,h=parseFloat(d.items.frame.style.left)||0,f=(b.previousOffset||0)+(h-f),c=-g/e*c.contentWidth+f,b.previousOffset=f,b.previousLeft=c,d.items.frame.style.left=c+"px",this.redrawCurrentTime(),this.redrawCustomTime(),this.redrawAxis(),this.trigger("rangechange");links.Timeline.preventDefault(a)};
links.Timeline.prototype.onMouseUp=function(){var a=this.eventParams,b=this.options;this.dom.frame.style.cursor="auto";a.onMouseMove&&(links.Timeline.removeEventListener(document,"mousemove",a.onMouseMove),delete a.onMouseMove);a.onMouseUp&&(links.Timeline.removeEventListener(document,"mouseup",a.onMouseUp),delete a.onMouseUp);if(a.customTime)this.trigger("timechanged");else if(a.editItem){var c=this.items[a.itemIndex];if(a.moved||a.addItem)this.applyAdd=this.applyChange=!0,this.updateData(a.itemIndex,
{start:c.start,end:c.end}),this.trigger(a.addItem?"add":"change"),a.addItem?this.applyAdd?this.updateData(a.itemIndex,{start:c.start,end:c.end,content:c.content,group:c.group?c.group.content:void 0}):this.deleteItem(a.itemIndex):this.applyChange?this.updateData(a.itemIndex,{start:c.start,end:c.end}):(delete this.applyChange,delete this.applyAdd,c=this.items[a.itemIndex],c.start=a.itemStart,c.end=a.itemEnd,this.repositionItem(c,a.itemLeft,a.itemRight)),this.recalcSize(),this.stackEvents(b.animate),
b.animate||this.redrawFrame(),this.redrawDeleteButton(),this.redrawDragAreas()}else!a.moved&&!a.zoomed?b.editable&&a.target===this.dom.items.deleteButton?(this.selection&&this.confirmDeleteItem(this.selection.index),this.redrawFrame()):b.selectable&&(a.itemIndex!==void 0?this.isSelected(a.itemIndex)||(this.selectItem(a.itemIndex),this.redrawDeleteButton(),this.redrawDragAreas(),this.trigger("select")):(this.unselectItem(),this.redrawDeleteButton(),this.redrawDragAreas())):(this.redrawFrame(),(a.moved&&
b.moveable||a.zoomed&&b.zoomable)&&this.trigger("rangechanged"))};
links.Timeline.prototype.onDblClick=function(a){var b=this.eventParams,c=this.options,d=this.dom,e=this.size,a=a||window.event;if(c.editable){if(b.itemIndex!==void 0)this.trigger("edit");else{var f=a.clientX-links.Timeline.getAbsoluteLeft(d.content),g=a.clientY-links.Timeline.getAbsoluteTop(d.content),d=this.screenToTime(f),e=this.screenToTime(f+e.frameWidth/10);c.snapEvents&&(this.step.snap(d),this.step.snap(e));c=this.getGroupFromHeight(g);this.addItem({start:d,end:e,content:"New",group:c.content});
b.itemIndex=this.items.length-1;this.selectItem(b.itemIndex);this.applyAdd=!0;this.trigger("add");this.applyAdd||this.deleteItem(b.itemIndex);this.redrawDeleteButton();this.redrawDragAreas()}links.Timeline.preventDefault(a)}};
links.Timeline.prototype.onMouseWheel=function(a){if(this.options.zoomable){if(!a)a=window.event;var b=0;a.wheelDelta?b=a.wheelDelta/120:a.detail&&(b=-a.detail/3);if(b){var c=this;(function(){c.recalcSize();var d=b/5,e=links.Timeline.getAbsoluteLeft(c.dom.content),e=a.clientX!=void 0&&e!=void 0?c.screenToTime(a.clientX-e):void 0;c.zoom(d,e);c.trigger("rangechange");c.trigger("rangechanged")})()}links.Timeline.preventDefault(a)}};
links.Timeline.prototype.zoom=function(a,b){b==void 0&&(b=new Date((this.start.valueOf()+this.end.valueOf())/2));a>=1&&(a=0.9);a<=-1&&(a=-0.9);a<0&&(a/=1+a);var c=parseFloat(this.start.valueOf()-b.valueOf()),d=parseFloat(this.end.valueOf()-b.valueOf());this.applyRange(new Date(this.start.valueOf()-c*a),new Date(this.end.valueOf()-d*a),b);this.recalcSize();c=this.options.animate?this.options.animateZoom:!1;this.stackEvents(c);(!c||this.groups.length>0)&&this.redrawFrame()};
links.Timeline.prototype.move=function(a){var b=parseFloat(this.end.valueOf()-this.start.valueOf());this.applyRange(new Date(this.start.valueOf()+b*a),new Date(this.end.valueOf()+b*a));this.recalcConversion();this.redrawFrame()};
links.Timeline.prototype.repositionItem=function(a,b,c){var d=a.dom;switch(a.type){case "range":d.style.left=b+"px";d.style.width=Math.max(c-b,1)+"px";break;case "box":d.style.left=b-a.width/2+"px";d.line.style.left=b-a.lineWidth/2+"px";d.dot.style.left=b-a.dotWidth/2+"px";break;case "dot":d.style.left=b-a.dotWidth/2+"px"}if(this.groups.length>0)d.style.top=a.top+"px"};
links.Timeline.prototype.applyRange=function(a,b,c){var a=a.valueOf(),b=b.valueOf(),d=b-a,e=this.options,f=Number(e.intervalMin)||10;f<10&&(f=10);var g=Number(e.intervalMax)||31536E10;g>31536E10&&(g=31536E10);g<f&&(g=f);var h=e.min?e.min.valueOf():void 0,e=e.max?e.max.valueOf():void 0;h&&e&&(h>=e&&(e=h+864E5),g>e-h&&(g=e-h),f>e-h&&(f=e-h));a>=b&&(b+=864E5);if(d<f){f-=d;var l=c?(c.valueOf()-a)/d:0.5;a-=Math.round(f*l);b+=Math.round(f*(1-l))}d>g&&(f=d-g,l=c?(c.valueOf()-a)/d:0.5,a+=Math.round(f*l),
b-=Math.round(f*(1-l)));h&&(f=a-h,f<0&&(a-=f,b-=f));e&&(f=e-b,f<0&&(a+=f,b+=f));this.start=new Date(a);this.end=new Date(b)};links.Timeline.prototype.confirmDeleteItem=function(a){this.applyDelete=!0;this.isSelected(a)||this.selectItem(a);this.trigger("delete");this.applyDelete&&this.deleteItem(a);delete this.applyDelete};
links.Timeline.prototype.deleteItem=function(a){if(a>=this.items.length)throw"Cannot delete row, index out of range";this.unselectItem();this.items.splice(a,1);if(this.data)if(google&&google.visualization&&this.data instanceof google.visualization.DataTable)this.data.removeRow(a);else if(links.Timeline.isArray(this.data))this.data.splice(a,1);else throw"Cannot delete row from data, unknown data type";this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(this.options.animate);
this.options.animate||this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.deleteAllItems=function(){this.unselectItem();this.items=[];this.deleteGroups();if(this.data)if(google&&google.visualization&&this.data instanceof google.visualization.DataTable)this.data.removeRows(0,this.data.getNumberOfRows());else if(links.Timeline.isArray(this.data))this.data.splice(0,this.data.length);else throw"Cannot delete row from data, unknown data type";this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(this.options.animate);this.options.animate||
this.redrawFrame();this.size.dataChanged=!1};links.Timeline.prototype.getGroupFromHeight=function(a){var b=this.groups,c=this.size;a-=this.options.axisOnTop?c.axis.height:0;if(b){for(var d,c=b.length-1;c>=0;c--)if(d=b[c],a>d.top)break;return d}};links.Timeline.prototype.getItem=function(a){if(a>=this.items.length)throw"Cannot get item, index out of range";var a=this.items[a],b={};b.start=new Date(a.start);if(a.end)b.end=new Date(a.end);b.content=a.content;if(a.group)b.group=a.group.content;return b};
links.Timeline.prototype.addItem=function(a){this.addItems([a])};links.Timeline.prototype.addItems=function(a){for(var b=this.items,c=0,d=a.length;c<d;c++){var e=a[c];this.addGroup(e.group);b.push(this.createItem(e));this.updateData(b.length-1,e)}this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(!1);this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.createItem=function(a){return{start:a.start,end:a.end,content:a.content,type:a.end?"range":this.options.style,group:this.findGroup(a.group),top:0,left:0,width:0,height:0,lineWidth:0,dotWidth:0,dotHeight:0}};
links.Timeline.prototype.changeItem=function(a,b){if(a>=this.items.length)throw"Cannot change item, index out of range";var c=this.items[a];if(b.start)c.start=b.start;if(b.end)c.end=b.end;if(b.content)c.content=b.content;if(b.group)c.group=this.addGroup(b.group);this.updateData(a,b);this.size.dataChanged=!0;this.redrawFrame();this.recalcSize();this.stackEvents(!1);this.redrawFrame();this.size.dataChanged=!1};
links.Timeline.prototype.findGroup=function(a){a=this.groupIndexes[a];return a!=void 0?this.groups[a]:void 0};links.Timeline.prototype.deleteGroups=function(){this.groups=[];this.groupIndexes={}};
links.Timeline.prototype.addGroup=function(a){var b=this.groups,c=this.groupIndexes,d=void 0,d=c[a];if(d===void 0&&a!==void 0){d={content:a,labelTop:0,lineTop:0};b.push(d);this.options.axisOnTop?b.sort(function(a,b){return a.content>b.content}):b.sort(function(a,b){return a.content<b.content});for(var a=0,e=b.length;a<e;a++)c[b[a].content]=a}else d=b[d];return d};links.Timeline.prototype.cancelChange=function(){this.applyChange=!1};
links.Timeline.prototype.cancelDelete=function(){this.applyDelete=!1};links.Timeline.prototype.cancelAdd=function(){this.applyAdd=!1};
links.Timeline.prototype.setSelection=function(a){if(a!=void 0&&a.length>0){if(a[0].row!=void 0){var b=a[0].row;if(this.items[b])return a=this.items[b],this.selectItem(b),b=a.start,a=a.end,a=a!=void 0?new Date((a.valueOf()+b.valueOf())/2):new Date(b),b=this.end.valueOf()-this.start.valueOf(),this.setVisibleChartRange(new Date(a.valueOf()-b/2),new Date(a.valueOf()+b/2)),!0}}else this.unselectItem();return!1};
links.Timeline.prototype.getSelection=function(){var a=[];this.selection&&a.push({row:this.selection.index});return a};
links.Timeline.prototype.selectItem=function(a){this.unselectItem();this.selection=void 0;if(this.items[a]!==void 0){var b=this.items[a],c=b.dom;this.selection={index:a,item:c};if(this.options.editable)c.style.cursor="move";switch(b.type){case "range":c.className="timeline-event timeline-event-selected timeline-event-range";break;case "box":c.className="timeline-event timeline-event-selected timeline-event-box";c.line.className="timeline-event timeline-event-selected timeline-event-line";c.dot.className=
"timeline-event timeline-event-selected timeline-event-dot";break;case "dot":c.className="timeline-event timeline-event-selected",c.dot.className="timeline-event timeline-event-selected timeline-event-dot"}}};links.Timeline.prototype.isSelected=function(a){return this.selection&&this.selection.index===a};
links.Timeline.prototype.unselectItem=function(){if(this.selection){var a=this.items[this.selection.index];if(a&&a.dom){var b=a.dom;b.style.cursor="";switch(a.type){case "range":b.className="timeline-event timeline-event-range";break;case "box":b.className="timeline-event timeline-event-box";b.line.className="timeline-event timeline-event-line";b.dot.className="timeline-event timeline-event-dot";break;case "dot":b.className="",b.dot.className="timeline-event timeline-event-dot"}}}this.selection=void 0};
links.Timeline.prototype.stackEvents=function(a){if(!(this.options.stackEvents==!1||this.groups.length>0)){a==void 0&&(a=!1);var b=this.stackOrder(this.items),c=this.stackCalculateFinal(b,a);if(a){var d=this.animation;if(!d)this.animation=d={};d.finalItems=c;var e=this,f=function(){var a=e.stackMoveOneStep(b,d.finalItems);e.recalcSize();e.redrawFrame();a?(delete d.finalItems,delete d.timer):d.timer=setTimeout(f,30)};if(!d.timer)d.timer=setTimeout(f,30)}else this.stackMoveToFinal(b,c),this.recalcSize()}};
links.Timeline.prototype.stackOrder=function(a){a=a.concat([]);a.sort(function(a,c){return a.type=="range"&&c.type!="range"?-1:a.type!="range"&&c.type=="range"?1:a.left-c.left});return a};
links.Timeline.prototype.stackCalculateFinal=function(a){for(var b=this.size.axis.top,c=this.options,d=c.axisOnTop,e=c.eventMargin,f=c.eventMarginAxis,c=[],g=0,h=a.length;g<h;g++){var l=a[g],o,m,r,q,n=l.height,p=l.width;o=d?b+f+e/2:b-n-f-e/2;q=o+n;switch(l.type){case "range":case "dot":m=this.timeToScreen(l.start);r=l.end?this.timeToScreen(l.end):m+p;break;case "box":m=this.timeToScreen(l.start)-p/2,r=m+p}c[g]={left:m,top:o,right:r,bottom:q,height:n,item:l}}g=0;for(h=c.length;g<h;g++){a=c[g];b=null;
do if(b=this.stackEventsCheckOverlap(c,g,0,g-1),b!=null)a.top=d?b.top+b.height+e:b.top-a.height-e,a.bottom=a.top+a.height;while(b)}return c};links.Timeline.prototype.stackMoveOneStep=function(a,b){var c=!0;for(i=0,iMax=a.length;i<iMax;i++){var d=b[i],e=d.item,f=parseInt(e.top),g=parseInt(d.top),h=g-f;if(h){var l=g==f?0:g>f?1:-1;Math.abs(h)>4&&(l=h/4);f=parseInt(f+l);f!=g&&(c=!1);e.top=f;e.bottom=e.top+e.height}else e.top=d.top,e.bottom=d.bottom;e.left=d.left;e.right=d.right}return c};
links.Timeline.prototype.stackMoveToFinal=function(a,b){for(i=0,iMax=a.length;i<iMax;i++){var c=a[i],d=b[i];c.left=d.left;c.top=d.top;c.right=d.right;c.bottom=d.bottom}};links.Timeline.prototype.stackEventsCheckOverlap=function(a,b,c,d){eventMargin=this.options.eventMargin;collision=this.collision;for(var e=a[b];d>=c;d--){var f=a[d];if(collision(e,f,eventMargin)&&d!=b)return f}};
links.Timeline.prototype.collision=function(a,b,c){c==void 0&&(c=0);return a.left-c<b.right&&a.right+c>b.left&&a.top-c<b.bottom&&a.bottom+c>b.top};links.Timeline.prototype.trigger=function(a){var b=null;switch(a){case "rangechange":case "rangechanged":b={start:new Date(this.start),end:new Date(this.end)};break;case "timechange":case "timechanged":b={time:new Date(this.customTime)}}links.events.trigger(this,a,b);google&&google.visualization&&google.visualization.events.trigger(this,a,b)};
links.events=links.events||{listeners:[],indexOf:function(a){for(var b=this.listeners,c=0,d=this.listeners.length;c<d;c++){var e=b[c];if(e&&e.object==a)return c}return-1},addListener:function(a,b,c){var d=this.listeners[this.indexOf(a)];d||(d={object:a,events:{}},this.listeners.push(d));a=d.events[b];a||(a=[],d.events[b]=a);a.indexOf(c)==-1&&a.push(c)},removeListener:function(a,b,c){var a=this.indexOf(a),d=this.listeners[a];if(d){var e=d.events[b];e&&(a=e.indexOf(c),a!=-1&&e.splice(a,1),e.length==
0&&delete d.events[b]);c=0;d=d.events;for(b in d)d.hasOwnProperty(b)&&c++;c==0&&delete this.listeners[a]}},removeAllListeners:function(){this.listeners=[]},trigger:function(a,b,c){if(a=this.listeners[this.indexOf(a)])if(b=a.events[b])for(var a=0,d=b.length;a<d;a++)b[a](c)}};links.Timeline.StepDate=function(a,b,c){this.current=new Date;this._start=new Date;this._end=new Date;this.autoScale=!0;this.scale=links.Timeline.StepDate.SCALE.DAY;this.step=1;this.setRange(a,b,c)};
links.Timeline.StepDate.SCALE={MILLISECOND:1,SECOND:2,MINUTE:3,HOUR:4,DAY:5,MONTH:6,YEAR:7};links.Timeline.StepDate.prototype.setRange=function(a,b,c){if(!isNaN(a)&&!isNaN(b))this._start=a!=void 0?new Date(a):new Date,this._end=b!=void 0?new Date(b):new Date,this.autoScale&&this.setMinimumStep(c)};links.Timeline.StepDate.prototype.start=function(){this.current=new Date(this._start);this.roundToMinor()};
links.Timeline.StepDate.prototype.roundToMinor=function(){switch(this.scale){case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.step*Math.floor(this.current.getFullYear()/this.step)),this.current.setMonth(0);case links.Timeline.StepDate.SCALE.MONTH:this.current.setDate(1);case links.Timeline.StepDate.SCALE.DAY:this.current.setHours(0);case links.Timeline.StepDate.SCALE.HOUR:this.current.setMinutes(0);case links.Timeline.StepDate.SCALE.MINUTE:this.current.setSeconds(0);case links.Timeline.StepDate.SCALE.SECOND:this.current.setMilliseconds(0)}if(this.step!=
1)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current.setMilliseconds(this.current.getMilliseconds()-this.current.getMilliseconds()%this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.setSeconds(this.current.getSeconds()-this.current.getSeconds()%this.step);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.setMinutes(this.current.getMinutes()-this.current.getMinutes()%this.step);break;case links.Timeline.StepDate.SCALE.HOUR:this.current.setHours(this.current.getHours()-
this.current.getHours()%this.step);break;case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()-1-(this.current.getDate()-1)%this.step+1);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()-this.current.getMonth()%this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()-this.current.getFullYear()%this.step)}};
links.Timeline.StepDate.prototype.end=function(){return this.current.getTime()>this._end.getTime()};
links.Timeline.StepDate.prototype.next=function(){var a=this.current.getTime();if(this.current.getMonth()<6)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current=new Date(this.current.getTime()+this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current=new Date(this.current.getTime()+this.step*1E3);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current=new Date(this.current.getTime()+this.step*6E4);break;case links.Timeline.StepDate.SCALE.HOUR:this.current=
new Date(this.current.getTime()+this.step*36E5);var b=this.current.getHours();this.current.setHours(b-b%this.step);break;case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()+this.step);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()+this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()+this.step)}else switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current=
new Date(this.current.getTime()+this.step);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.setSeconds(this.current.getSeconds()+this.step);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.setMinutes(this.current.getMinutes()+this.step);break;case links.Timeline.StepDate.SCALE.HOUR:this.current.setHours(this.current.getHours()+this.step);break;case links.Timeline.StepDate.SCALE.DAY:this.current.setDate(this.current.getDate()+this.step);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.setMonth(this.current.getMonth()+
this.step);break;case links.Timeline.StepDate.SCALE.YEAR:this.current.setFullYear(this.current.getFullYear()+this.step)}if(this.step!=1)switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:this.current.getMilliseconds()<this.step&&this.current.setMilliseconds(0);break;case links.Timeline.StepDate.SCALE.SECOND:this.current.getSeconds()<this.step&&this.current.setSeconds(0);break;case links.Timeline.StepDate.SCALE.MINUTE:this.current.getMinutes()<this.step&&this.current.setMinutes(0);break;
case links.Timeline.StepDate.SCALE.HOUR:this.current.getHours()<this.step&&this.current.setHours(0);break;case links.Timeline.StepDate.SCALE.DAY:this.current.getDate()<this.step+1&&this.current.setDate(1);break;case links.Timeline.StepDate.SCALE.MONTH:this.current.getMonth()<this.step&&this.current.setMonth(0)}if(this.current.getTime()==a)this.current=new Date(this._end)};links.Timeline.StepDate.prototype.getCurrent=function(){return this.current};
links.Timeline.StepDate.prototype.setScale=function(a,b){this.scale=a;if(b>0)this.step=b;this.autoScale=!1};links.Timeline.StepDate.prototype.setAutoScale=function(a){this.autoScale=a};
links.Timeline.StepDate.prototype.setMinimumStep=function(a){if(a!=void 0){if(31104E9>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=1E3;if(15552E9>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=500;if(31104E8>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=100;if(15552E8>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=50;if(31104E7>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=10;if(15552E7>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=
5;if(31104E6>a)this.scale=links.Timeline.StepDate.SCALE.YEAR,this.step=1;if(7776E6>a)this.scale=links.Timeline.StepDate.SCALE.MONTH,this.step=3;if(2592E6>a)this.scale=links.Timeline.StepDate.SCALE.MONTH,this.step=1;if(432E6>a)this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=5;if(1728E5>a)this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=2;if(864E5>a)this.scale=links.Timeline.StepDate.SCALE.DAY,this.step=1;if(144E5>a)this.scale=links.Timeline.StepDate.SCALE.HOUR,this.step=4;if(36E5>a)this.scale=
links.Timeline.StepDate.SCALE.HOUR,this.step=1;if(9E5>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=15;if(6E5>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=10;if(3E5>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=5;if(6E4>a)this.scale=links.Timeline.StepDate.SCALE.MINUTE,this.step=1;if(15E3>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=15;if(1E4>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=10;if(5E3>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,
this.step=5;if(1E3>a)this.scale=links.Timeline.StepDate.SCALE.SECOND,this.step=1;if(200>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=200;if(100>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=100;if(50>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=50;if(10>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=10;if(5>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,this.step=5;if(1>a)this.scale=links.Timeline.StepDate.SCALE.MILLISECOND,
this.step=1}};
links.Timeline.StepDate.prototype.snap=function(a){if(this.scale==links.Timeline.StepDate.SCALE.YEAR){var b=a.getFullYear()+Math.round(a.getMonth()/12);a.setFullYear(Math.round(b/this.step)*this.step);a.setMonth(0);a.setDate(0);a.setHours(0);a.setMinutes(0);a.setSeconds(0);a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.MONTH)a.getDate()>15?(a.setDate(1),a.setMonth(a.getMonth()+1)):a.setDate(1),a.setHours(0),a.setMinutes(0),a.setSeconds(0),a.setMilliseconds(0);else if(this.scale==
links.Timeline.StepDate.SCALE.DAY){switch(this.step){case 5:case 2:a.setHours(Math.round(a.getHours()/24)*24);break;default:a.setHours(Math.round(a.getHours()/12)*12)}a.setMinutes(0);a.setSeconds(0);a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.HOUR){switch(this.step){case 4:a.setMinutes(Math.round(a.getMinutes()/60)*60);break;default:a.setMinutes(Math.round(a.getMinutes()/30)*30)}a.setSeconds(0);a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.MINUTE){switch(this.step){case 15:case 10:a.setMinutes(Math.round(a.getMinutes()/
5)*5);a.setSeconds(0);break;case 5:a.setSeconds(Math.round(a.getSeconds()/60)*60);break;default:a.setSeconds(Math.round(a.getSeconds()/30)*30)}a.setMilliseconds(0)}else if(this.scale==links.Timeline.StepDate.SCALE.SECOND)switch(this.step){case 15:case 10:a.setSeconds(Math.round(a.getSeconds()/5)*5);a.setMilliseconds(0);break;case 5:a.setMilliseconds(Math.round(a.getMilliseconds()/1E3)*1E3);break;default:a.setMilliseconds(Math.round(a.getMilliseconds()/500)*500)}else this.scale==links.Timeline.StepDate.SCALE.MILLISECOND&&
(b=this.step>5?this.step/2:1,a.setMilliseconds(Math.round(a.getMilliseconds()/b)*b))};
links.Timeline.StepDate.prototype.isMajor=function(){switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return this.current.getMilliseconds()==0;case links.Timeline.StepDate.SCALE.SECOND:return this.current.getSeconds()==0;case links.Timeline.StepDate.SCALE.MINUTE:return this.current.getHours()==0&&this.current.getMinutes()==0;case links.Timeline.StepDate.SCALE.HOUR:return this.current.getHours()==0;case links.Timeline.StepDate.SCALE.DAY:return this.current.getDate()==1;case links.Timeline.StepDate.SCALE.MONTH:return this.current.getMonth()==
0;case links.Timeline.StepDate.SCALE.YEAR:return!1;default:return!1}};
links.Timeline.StepDate.prototype.getLabelMinor=function(a){var b="Jan,Feb,Mar,Apr,May,Jun,Jul,Aug,Sep,Oct,Nov,Dec".split(",");if(a==void 0)a=this.current;switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return String(a.getMilliseconds());case links.Timeline.StepDate.SCALE.SECOND:return String(a.getSeconds());case links.Timeline.StepDate.SCALE.MINUTE:return this.addZeros(a.getHours(),2)+":"+this.addZeros(a.getMinutes(),2);case links.Timeline.StepDate.SCALE.HOUR:return this.addZeros(a.getHours(),
2)+":"+this.addZeros(a.getMinutes(),2);case links.Timeline.StepDate.SCALE.DAY:return String(a.getDate());case links.Timeline.StepDate.SCALE.MONTH:return b[a.getMonth()];case links.Timeline.StepDate.SCALE.YEAR:return String(a.getFullYear());default:return""}};
links.Timeline.StepDate.prototype.getLabelMajor=function(a){var b="January,February,March,April,May,June,July,August,September,October,November,December".split(","),c="Sunday,Monday,Tuesday,Wednesday,Thursday,Friday,Saturday".split(",");if(a==void 0)a=this.current;switch(this.scale){case links.Timeline.StepDate.SCALE.MILLISECOND:return this.addZeros(a.getHours(),2)+":"+this.addZeros(a.getMinutes(),2)+":"+this.addZeros(a.getSeconds(),2);case links.Timeline.StepDate.SCALE.SECOND:return a.getDate()+
" "+b[a.getMonth()]+" "+this.addZeros(a.getHours(),2)+":"+this.addZeros(a.getMinutes(),2);case links.Timeline.StepDate.SCALE.MINUTE:return c[a.getDay()]+" "+a.getDate()+" "+b[a.getMonth()]+" "+a.getFullYear();case links.Timeline.StepDate.SCALE.HOUR:return c[a.getDay()]+" "+a.getDate()+" "+b[a.getMonth()]+" "+a.getFullYear();case links.Timeline.StepDate.SCALE.DAY:return b[a.getMonth()]+" "+a.getFullYear();case links.Timeline.StepDate.SCALE.MONTH:return String(a.getFullYear());default:return""}};
links.Timeline.StepDate.prototype.addZeros=function(a,b){for(var c=""+a;c.length<b;)c="0"+c;return c};
links.imageloader=function(){function a(a){if(c[a]==!0)return!0;var b=new Image;b.src=a;return b.complete?!0:!1}function b(a){return d[a]!=void 0}var c={},d={};return{isLoaded:a,isLoading:b,load:function(e,f,g){g==void 0&&(g=!0);if(a(e))g&&f(e);else if(!b(e)||g){var h=d[e];if(!h)g=new Image,g.src=e,h=[],d[e]=h,g.onload=function(){c[e]=!0;delete d[e];for(var a=0;a<h.length;a++)h[a](e)};h.indexOf(f)==-1&&h.push(f)}}}}();
links.Timeline.addEventListener=function(a,b,c,d){a.addEventListener?(d===void 0&&(d=!1),b==="mousewheel"&&navigator.userAgent.indexOf("Firefox")>=0&&(b="DOMMouseScroll"),a.addEventListener(b,c,d)):a.attachEvent("on"+b,c)};links.Timeline.removeEventListener=function(a,b,c,d){a.removeEventListener?(d===void 0&&(d=!1),b==="mousewheel"&&navigator.userAgent.indexOf("Firefox")>=0&&(b="DOMMouseScroll"),a.removeEventListener(b,c,d)):a.detachEvent("on"+b,c)};
links.Timeline.getTarget=function(a){if(!a)a=window.event;var b;if(a.target)b=a.target;else if(a.srcElement)b=a.srcElement;if(b.nodeType!==void 0&&b.nodeType==3)b=b.parentNode;return b};links.Timeline.stopPropagation=function(a){if(!a)a=window.event;a.stopPropagation?a.stopPropagation():a.cancelBubble=!0};links.Timeline.preventDefault=function(a){if(!a)a=window.event;a.preventDefault?a.preventDefault():a.returnValue=!1};
links.Timeline.getAbsoluteLeft=function(a){for(var b=0;a!=null;)b+=a.offsetLeft,b-=a.scrollLeft,a=a.offsetParent;!document.body.scrollLeft&&window.pageXOffset&&(b-=window.pageXOffset);return b};links.Timeline.getAbsoluteTop=function(a){for(var b=0;a!=null;)b+=a.offsetTop,b-=a.scrollTop,a=a.offsetParent;!document.body.scrollTop&&window.pageYOffset&&(b-=window.pageYOffset);return b};links.Timeline.isArray=function(a){return a instanceof Array?!0:Object.prototype.toString.call(a)==="[object Array]"};
